/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.util.binary;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.simantics.databoard.util.binary.BinaryReadable;

public class ByteBufferReadable
implements BinaryReadable {
    ByteBuffer buf;

    public ByteBufferReadable(ByteBuffer buf) {
        if (buf == null) {
            throw new IllegalArgumentException("null");
        }
        this.buf = buf;
    }

    public ByteBufferReadable(byte[] buf) {
        if (buf == null) {
            throw new IllegalArgumentException("null");
        }
        this.buf = ByteBuffer.wrap(buf);
    }

    @Override
    public byte readByte() {
        return this.buf.get();
    }

    int _read() {
        if (this.buf.position() >= this.buf.limit()) {
            return -1;
        }
        return this.buf.get() & 0xFF;
    }

    @Override
    public final String readLine() throws IOException {
        StringBuffer input = new StringBuffer();
        int c = -1;
        boolean eol = false;
        block4: while (!eol) {
            c = this._read();
            switch (c) {
                case -1: 
                case 10: {
                    eol = true;
                    break;
                }
                case 13: {
                    eol = true;
                    long cur = this.position();
                    if (this._read() == 10) continue block4;
                    this.position(cur);
                    break;
                }
                default: {
                    input.append((char)c);
                }
            }
        }
        if (c == -1 && input.length() == 0) {
            return null;
        }
        return input.toString();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.buf.get() & 0xFF;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.buf.get() != 0;
    }

    @Override
    public void readFully(byte[] dst, int offset, int length) {
        this.buf.get(dst, offset, length);
    }

    @Override
    public void readFully(byte[] dst) {
        this.buf.get(dst);
    }

    @Override
    public void readFully(ByteBuffer buf) {
        if (buf.hasArray()) {
            this.buf.get(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining());
            buf.position(buf.capacity());
        } else {
            buf.put(buf);
        }
    }

    @Override
    public void readFully(ByteBuffer buf, int length) {
        if (buf.hasArray()) {
            this.buf.get(buf.array(), buf.arrayOffset() + buf.position(), length);
            buf.position(buf.position() + length);
        } else {
            int len = length;
            int origLimit = this.buf.limit();
            try {
                this.buf.limit(this.buf.position() + len);
                buf.put(this.buf);
            }
            finally {
                this.buf.limit(origLimit);
            }
        }
    }

    @Override
    public double readDouble() {
        return this.buf.getDouble();
    }

    @Override
    public float readFloat() {
        return this.buf.getFloat();
    }

    @Override
    public int readInt() {
        return this.buf.getInt();
    }

    @Override
    public long readLong() {
        return this.buf.getLong();
    }

    @Override
    public short readShort() {
        return this.buf.getShort();
    }

    @Override
    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    @Override
    public char readChar() throws IOException {
        return this.buf.getChar();
    }

    @Override
    public int readUnsignedShort() {
        return this.buf.getShort() & 0xFFFF;
    }

    @Override
    public long length() {
        return this.buf.limit();
    }

    @Override
    public long position() {
        return this.buf.position();
    }

    public ByteOrder order() {
        return this.buf.order();
    }

    public void order(ByteOrder order) {
        this.buf.order(order);
    }

    public void position(int newPosition) throws IOException {
        this.buf.position(newPosition);
    }

    public void position(long newPosition) throws IOException {
        if (newPosition >= Integer.MAX_VALUE || newPosition < 0L) {
            throw new IllegalArgumentException("index out of range");
        }
        this.buf.position((int)newPosition);
    }

    @Override
    public long skipBytes(long bytes) throws IOException {
        long newPosition = bytes + this.position();
        this.position(newPosition);
        return bytes;
    }

    @Override
    public int skipBytes(int bytes) throws IOException {
        long newPosition = (long)bytes + this.position();
        this.position(newPosition);
        return bytes;
    }
}

