/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.util.binary;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.util.EnumSet;

public class BinaryFile2 {
    RandomAccessFile raf;
    File file;
    ByteOrder order = ByteOrder.BIG_ENDIAN;
    Block first = null;
    int buf_size;
    long pointer = 0L;

    public BinaryFile2(RandomAccessFile file, int buf_size) throws IOException {
        this.raf = file;
        this.buf_size = buf_size;
    }

    public BinaryFile2(File file, int buf_size) throws IOException {
        this.raf = new RandomAccessFile(file, "rw");
        this.file = file;
        this.buf_size = buf_size;
    }

    public synchronized void close() throws IOException {
        if (this.raf == null) {
            return;
        }
        this.flush();
        this.pointer = -1L;
        this.raf.close();
        this.raf = null;
        this.first = null;
    }

    public File file() {
        return this.file;
    }

    public RandomAccessFile getRandomAccessFile() {
        return this.raf;
    }

    public ByteOrder order() {
        return this.order;
    }

    public void order(ByteOrder order) {
        if (order == null) {
            throw new IllegalArgumentException("null argument");
        }
        this.order = order;
    }

    public void flush() throws IOException {
    }

    static class Block {
        int size;
        long file_pos;
        byte[] buf;
        int access_time;
        EnumSet<Flag> flags;
        Block next;

        Block() {
        }
    }

    static enum Flag {
        File,
        Memory,
        Cache;

    }
}

