/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.util;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public final class URIUtil {
    static final Charset UTF8;
    static final byte[] encodeTable;
    static final byte[] encodeTable2;
    static final int[] fileNameEncodeTable;

    static {
        char c;
        UTF8 = Charset.forName("UTF-8");
        encodeTable = new byte[128];
        encodeTable2 = new byte[128];
        int i = 0;
        while (i < 128) {
            c = (char)i;
            URIUtil.encodeTable[i] = c == ' ' ? 95 : (Character.isJavaIdentifierPart(c) && c != '_' && c != '$' ? (int)i : -1);
            ++i;
        }
        i = 0;
        while (i < 128) {
            c = (char)i;
            URIUtil.encodeTable2[i] = c == ' ' || c == '_' || c == '(' || c == ')' ? (int)i : (c == '/' ? 45 : (c == ' ' ? 95 : (c == '-' || c == '.' ? (int)i : (Character.isJavaIdentifierPart(c) && c != '_' && c != '$' ? (int)i : -1))));
            ++i;
        }
        fileNameEncodeTable = new int[128];
        i = 0;
        while (i < fileNameEncodeTable.length) {
            if (i < 32) {
                URIUtil.fileNameEncodeTable[i] = -1;
            } else {
                switch ((char)i) {
                    case '\"': 
                    case '*': 
                    case '/': 
                    case ':': 
                    case '<': 
                    case '>': 
                    case '?': 
                    case '\\': 
                    case '|': {
                        URIUtil.fileNameEncodeTable[i] = -1;
                        break;
                    }
                    default: {
                        URIUtil.fileNameEncodeTable[i] = i;
                    }
                }
            }
            ++i;
        }
    }

    public static byte[] encode(String str, byte escapeChar, boolean identifier) throws UnsupportedEncodingException {
        byte[] bytes = str.getBytes(UTF8);
        boolean prefixWithUnderscore = identifier && bytes.length > 0 && (bytes[0] == 95 || Character.isDigit(bytes[0]));
        int length = bytes.length;
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (b < 0 || encodeTable[b] == -1) {
                length += 2;
            }
            ++n2;
        }
        if (prefixWithUnderscore) {
            ++length;
        }
        if (length == bytes.length) {
            int i = 0;
            while (i < length) {
                bytes[i] = encodeTable[bytes[i]];
                ++i;
            }
            return bytes;
        }
        byte[] result = new byte[length];
        int pos = 0;
        if (prefixWithUnderscore) {
            result[pos++] = 95;
        }
        byte[] byArray2 = bytes;
        int n3 = bytes.length;
        int n4 = 0;
        while (n4 < n3) {
            block9: {
                int ib;
                block8: {
                    block7: {
                        int b = byArray2[n4];
                        ib = b;
                        if (ib < 0) break block7;
                        byte eb = encodeTable[ib];
                        if (eb < 0) break block8;
                        result[pos++] = eb;
                        break block9;
                    }
                    ib += 256;
                }
                result[pos++] = escapeChar;
                result[pos++] = (byte)Character.forDigit(ib >> 4, 16);
                result[pos++] = (byte)Character.forDigit(ib & 0xF, 16);
            }
            ++n4;
        }
        return result;
    }

    public static byte[] encodeFilename(String str, byte escapeChar, boolean identifier) throws UnsupportedEncodingException {
        byte[] bytes = str.getBytes(UTF8);
        boolean prefixWithUnderscore = identifier && bytes.length > 0 && (bytes[0] == 95 || Character.isDigit(bytes[0]));
        int length = bytes.length;
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (b < 0 || encodeTable2[b] == -1) {
                length += 2;
            }
            ++n2;
        }
        if (prefixWithUnderscore) {
            ++length;
        }
        if (length == bytes.length) {
            int i = 0;
            while (i < length) {
                bytes[i] = encodeTable2[bytes[i]];
                ++i;
            }
            return bytes;
        }
        byte[] result = new byte[length];
        int pos = 0;
        if (prefixWithUnderscore) {
            result[pos++] = 95;
        }
        byte[] byArray2 = bytes;
        int n3 = bytes.length;
        int n4 = 0;
        while (n4 < n3) {
            block9: {
                int ib;
                block8: {
                    block7: {
                        int b = byArray2[n4];
                        ib = b;
                        if (ib < 0) break block7;
                        byte eb = encodeTable2[ib];
                        if (eb < 0) break block8;
                        result[pos++] = eb;
                        break block9;
                    }
                    ib += 256;
                }
                result[pos++] = escapeChar;
                result[pos++] = (byte)Character.forDigit(ib >> 4, 16);
                result[pos++] = (byte)Character.forDigit(ib & 0xF, 16);
            }
            ++n4;
        }
        return result;
    }

    public static String encodeFilename(String str) {
        try {
            byte[] result = URIUtil.encodeFilename(str, (byte)37, false);
            return new String(result, 0, result.length);
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    public static String encodeURI(String str) {
        try {
            byte[] result = URIUtil.encode(str, (byte)37, false);
            return new String(result, 0, result.length);
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    public static String encodeIdentifier(String str) {
        try {
            byte[] result = URIUtil.encode(str, (byte)36, true);
            return new String(result, 0, result.length);
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    public static String decode(byte[] bytes, byte escapeChar, boolean identifier) {
        int length = 0;
        int startPos = 0;
        int i = 0;
        if (identifier && bytes.length > 0 && bytes[0] == 95) {
            startPos = 1;
            i = 1;
        }
        while (i < bytes.length) {
            byte b = bytes[i];
            if (b == escapeChar) {
                i += 2;
            }
            ++length;
            ++i;
        }
        int pos = 0;
        byte[] result = new byte[length];
        int i2 = startPos;
        while (i2 < bytes.length) {
            byte b = bytes[i2];
            if (b == escapeChar) {
                int c = Character.digit((char)bytes[++i2], 16);
                c *= 16;
                result[pos] = (byte)(c += Character.digit((char)bytes[++i2], 16));
            } else {
                result[pos] = b == 95 ? (byte)32 : b;
            }
            ++pos;
            ++i2;
        }
        return new String(result, UTF8);
    }

    public static String decodeURI(String str) {
        return URIUtil.decode(str.getBytes(), (byte)37, false);
    }

    public static String decodeIdentifier(String str) {
        return URIUtil.decode(str.getBytes(), (byte)36, true);
    }

    public static String encodeFilename2(String str) {
        return URIUtil.encodeFilename2(str, '%');
    }

    private static String encodeFilename2(String str, char escapeChar) {
        int originalLength;
        int length = originalLength = str.length();
        int i = 0;
        while (i < originalLength) {
            char c = str.charAt(i);
            if (c < '\u0080' && fileNameEncodeTable[c] == -1) {
                length += 2;
            }
            ++i;
        }
        if (length == originalLength) {
            return str;
        }
        char[] result = new char[length];
        int pos = 0;
        int i2 = 0;
        while (i2 < originalLength) {
            char c;
            char ic = c = str.charAt(i2);
            if (c >= '\u0080') {
                result[pos++] = c;
            } else {
                int ec = fileNameEncodeTable[ic];
                if (ec >= 0) {
                    result[pos++] = (char)ec;
                } else {
                    result[pos++] = escapeChar;
                    result[pos++] = Character.forDigit(ic >> 4, 16);
                    result[pos++] = Character.forDigit(ic & 0xF, 16);
                }
            }
            ++i2;
        }
        return new String(result);
    }
}

