/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.util;

import java.util.Arrays;
import java.util.List;

public final class URIStringUtils {
    public static final char NAMESPACE_PATH_SEPARATOR = '/';
    public static final char NAMESPACE_LOCAL_SEPARATOR = '#';
    private static final String HTTP_PREFIX = "http://";
    private static final int HTTP_POSITION = "http://".length();
    private static boolean[] ESCAPED_US_ASCII_CHARS = new boolean[128];

    static {
        URIStringUtils.ESCAPED_US_ASCII_CHARS[32] = true;
        URIStringUtils.ESCAPED_US_ASCII_CHARS[37] = true;
        URIStringUtils.ESCAPED_US_ASCII_CHARS[35] = true;
        URIStringUtils.ESCAPED_US_ASCII_CHARS[47] = true;
        URIStringUtils.ESCAPED_US_ASCII_CHARS[38] = true;
    }

    private static int assertSingleSeparatorPosition(String uri) {
        int sharpIndex = uri.indexOf(35);
        if (sharpIndex == -1) {
            throw new IllegalArgumentException("URI '" + uri + "' does not contain any '#' separator characters");
        }
        int nextSharpIndex = uri.indexOf(35, sharpIndex + 1);
        if (nextSharpIndex != -1) {
            throw new IllegalArgumentException("URI '" + uri + "' contains multiple '#' separator characters");
        }
        return sharpIndex;
    }

    private static int singleSeparatorPosition(String uri) {
        int sharpIndex = uri.indexOf(35);
        if (sharpIndex == -1) {
            return -1;
        }
        int nextSharpIndex = uri.indexOf(35, sharpIndex + 1);
        if (nextSharpIndex != -1) {
            return -1;
        }
        return sharpIndex;
    }

    public static String getNamespace(String uri) {
        if (uri == null) {
            throw new NullPointerException("null uri");
        }
        int separatorIndex = URIStringUtils.assertSingleSeparatorPosition(uri);
        return uri.substring(0, separatorIndex);
    }

    public static String getRVIParent(String uri) {
        int childSeparator = uri.lastIndexOf(47);
        int propertySeparator = uri.lastIndexOf(35);
        int separator = Math.max(childSeparator, propertySeparator);
        return uri.substring(0, separator);
    }

    public static String getLocalName(String uri) {
        if (uri == null) {
            throw new NullPointerException("null uri");
        }
        int separatorIndex = URIStringUtils.assertSingleSeparatorPosition(uri);
        return uri.substring(separatorIndex + 1);
    }

    public static String escapeName(String name) {
        char[] chars = name.toCharArray();
        boolean modified = false;
        int i = 0;
        while (i < chars.length) {
            if (!Character.isJavaIdentifierPart(chars[i])) {
                chars[i] = 95;
                modified = true;
            }
            ++i;
        }
        if (modified) {
            return new String(chars);
        }
        return name;
    }

    public static String[] splitURI(String uri) {
        int nextPathSeparator = uri.lastIndexOf(47);
        if (nextPathSeparator == -1) {
            return null;
        }
        if (nextPathSeparator == HTTP_POSITION - 1) {
            if (uri.startsWith(HTTP_PREFIX)) {
                return new String[]{HTTP_PREFIX, uri.substring(HTTP_POSITION, uri.length())};
            }
            return null;
        }
        return new String[]{uri.substring(0, nextPathSeparator), uri.substring(nextPathSeparator + 1, uri.length())};
    }

    public static List<String> splitURISCL(String uri) {
        String[] result = URIStringUtils.splitURI(uri);
        return Arrays.asList(result);
    }

    public static String[] trySplitNamespaceAndLocalName(String uri) {
        String[] stringArray;
        if (uri == null) {
            throw new NullPointerException("null uri");
        }
        int separatorIndex = URIStringUtils.singleSeparatorPosition(uri);
        if (separatorIndex == -1) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[2];
            stringArray2[0] = uri.substring(0, separatorIndex);
            stringArray = stringArray2;
            stringArray2[1] = uri.substring(separatorIndex + 1);
        }
        return stringArray;
    }

    public static String[] splitNamespaceAndLocalName(String uri) {
        if (uri == null) {
            throw new NullPointerException("null uri");
        }
        int separatorIndex = URIStringUtils.assertSingleSeparatorPosition(uri);
        return new String[]{uri.substring(0, separatorIndex), uri.substring(separatorIndex + 1)};
    }

    public static String escapeURI(String localName) {
        if (localName == null) {
            throw new NullPointerException("null local name");
        }
        return URIStringUtils.encode(localName);
    }

    public static String appendURINamespace(String namespace, String suffix) {
        return new StringBuilder(namespace.length() + 1 + suffix.length()).append(namespace).append('/').append(suffix).toString();
    }

    public static String makeURI(String namespace, String localName) {
        String escapedLocalName = URIStringUtils.escapeURI(localName);
        return new StringBuilder(namespace.length() + 1 + escapedLocalName.length()).append(namespace).append('#').append(escapedLocalName).toString();
    }

    public static String escape(String unicode) {
        return URIStringUtils.encode(unicode);
    }

    private static int needsEscaping(String unicode) {
        int len = unicode.length();
        int escapeCount = 0;
        int i = 0;
        while (i < len) {
            char ch = unicode.charAt(i);
            if (ch < '\u0080' && ESCAPED_US_ASCII_CHARS[ch]) {
                ++escapeCount;
            }
            ++i;
        }
        return escapeCount;
    }

    private static String encode(String unicode) {
        int needsEscapes = URIStringUtils.needsEscaping(unicode);
        if (needsEscapes == 0) {
            return unicode;
        }
        int len = unicode.length();
        char[] result = new char[len - needsEscapes + needsEscapes * 3];
        int in = 0;
        int out = 0;
        while (in < len) {
            char inCh;
            if ((inCh = unicode.charAt(in++)) >= '\u0080' || !ESCAPED_US_ASCII_CHARS[inCh]) {
                result[out++] = inCh;
                continue;
            }
            int c = inCh & 0xFF;
            result[out++] = 37;
            result[out++] = (char)URIStringUtils.hexEncode(c / 16);
            result[out++] = (char)URIStringUtils.hexEncode(c % 16);
        }
        return new String(result, 0, out);
    }

    private static boolean needsUnescaping(String unicode) {
        return unicode.indexOf(37) > -1;
    }

    public static String unescape(String uri) {
        try {
            if (!URIStringUtils.needsUnescaping(uri)) {
                return uri;
            }
            int len = uri.length();
            String unicode = uri;
            char[] result = new char[len];
            int in = 0;
            int out = 0;
            while (in < len) {
                char inCh;
                if ((inCh = unicode.charAt(in++)) == '%') {
                    char d1 = unicode.charAt(in);
                    char d2 = unicode.charAt(in + 1);
                    if (d1 > '\u007f' || d2 > '\u007f') {
                        throw new IllegalArgumentException("Invalid hex digit escape sequence in " + uri + " at " + in);
                    }
                    result[out++] = (char)(URIStringUtils.hexDecode((byte)d1) * 16 | URIStringUtils.hexDecode((byte)d2));
                    in += 2;
                    continue;
                }
                result[out++] = inCh;
            }
            return new String(result, 0, out);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Problem while unescaping string: " + uri, e);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Incomplete hex digit escape sequence in " + uri);
        }
    }

    private static byte hexEncode(int i) {
        if (i < 10) {
            return (byte)(48 + i);
        }
        return (byte)(65 + i - 10);
    }

    private static int hexDecode(byte b) {
        switch (b) {
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                return (b & 0xFF) - 97 + 10;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                return b - 65 + 10;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return b - 48;
            }
        }
        throw new IllegalArgumentException("Bad Hex escape character: " + (b & 0xFF));
    }

    public static void main(String[] args) {
        String s = URIStringUtils.makeURI("http://foo.bar.com/foo/bar", "baz/guuk/org%2Fnet");
        System.out.println("escapeURI: " + s);
        System.out.println("getNamespace: " + URIStringUtils.getNamespace(s));
        System.out.println("getLocalName: " + URIStringUtils.getLocalName(s));
        System.out.println("escapeURI: " + URIStringUtils.escapeURI("foo/bar/org%2Fnet"));
        System.out.println("escapeURI('...#...'): " + URIStringUtils.escapeURI("foo/bar#org%2Fnet"));
        URIStringUtils.testEscape("/", "%2F");
        URIStringUtils.testEscape("#", "%23");
        URIStringUtils.testEscape("%", "%25");
        URIStringUtils.testEscape("%01", "%2501");
        URIStringUtils.testEscape("%GG", "%25GG");
        URIStringUtils.testEscape("s\ufffd\ufffdt\ufffd venttiili", "s\ufffd\ufffdt\ufffd%20venttiili");
        URIStringUtils.testEscape("s\ufffd\ufffdt\ufffd", "s\ufffd\ufffdt\ufffd");
        URIStringUtils.testEscape("Something / Else", "Something%20%2F%20Else");
        URIStringUtils.testEscape("http://www.vtt.fi%2FSome- %25 Namespace/Something", "http:%2F%2Fwww.vtt.fi%252FSome-%20%2525%20Namespace%2FSomething");
        URIStringUtils.testEscape("http://www.vtt.fi/PSK", "http:%2F%2Fwww.vtt.fi%2FPSK");
        URIStringUtils.testEscape("http://www.vtt.fi%2FSome-Namespace/Something / Else", "http:%2F%2Fwww.vtt.fi%252FSome-Namespace%2FSomething%20%2F%20Else");
    }

    private static void testEscape(String unescaped, String expectedEscaped) {
        String esc = URIStringUtils.escape(unescaped);
        String unesc = URIStringUtils.unescape(esc);
        System.out.format("escape('%s') -> '%s', unescape('%s') -> '%s'", unescaped, esc, esc, unesc);
        if (!esc.equals(expectedEscaped)) {
            throw new AssertionError((Object)("escape('" + unescaped + "') was expected to return '" + expectedEscaped + "' but returned '" + esc + "'"));
        }
        if (!unesc.equals(unescaped)) {
            throw new AssertionError((Object)("unescape(escape('" + unescaped + "'))=unescape(" + esc + ") was expected to return '" + unescaped + "' but returned '" + unesc + "'"));
        }
        System.out.println(" OK");
    }
}

