/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.util;

import org.simantics.databoard.annotations.Union;
import org.simantics.databoard.util.NumberComparator;

@Union(value={Nolimit.class, Inclusive.class, Exclusive.class, InclusiveLong.class, ExclusiveLong.class})
public abstract class Limit {
    private static Limit NOLIMIT = new Nolimit();

    public static Limit nolimit() {
        return NOLIMIT;
    }

    public static Limit inclusive(Byte value) {
        return value == null ? NOLIMIT : new InclusiveLong(value.longValue());
    }

    public static Limit inclusive(Integer value) {
        return value == null ? NOLIMIT : new InclusiveLong(value.longValue());
    }

    public static Limit inclusive(Long value) {
        return value == null ? NOLIMIT : new InclusiveLong(value);
    }

    public static Limit inclusive(Float value) {
        return value == null ? NOLIMIT : new Inclusive(value.doubleValue());
    }

    public static Limit inclusive(Double value) {
        return value == null ? NOLIMIT : new Inclusive(value);
    }

    public static Limit exclusive(Byte value) {
        return value == null ? NOLIMIT : new ExclusiveLong(value.longValue());
    }

    public static Limit exclusive(Integer value) {
        return value == null ? NOLIMIT : new ExclusiveLong(value.longValue());
    }

    public static Limit exclusive(Long value) {
        return value == null ? NOLIMIT : new ExclusiveLong(value);
    }

    public static Limit exclusive(Float value) {
        return value == null ? NOLIMIT : new Exclusive(value.doubleValue());
    }

    public static Limit exclusive(Double value) {
        return value == null ? NOLIMIT : new Exclusive(value);
    }

    public abstract boolean isInclusive();

    public abstract boolean isExclusive();

    public abstract Number getValue();

    public abstract Integer smallestIncludedInteger();

    public abstract Integer greatestIncludedInteger();

    Limit() {
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Limit)) {
            return false;
        }
        Limit other = (Limit)obj;
        Number ln = this.getValue();
        Number on = other.getValue();
        return this.isInclusive() == other.isInclusive() && this.isExclusive() == other.isExclusive() && (ln == null ? on == null : on != null && NumberComparator.INSTANCE.compare(ln, on) == 0);
    }

    public String toString() {
        return this.getValue().toString();
    }

    public static class Exclusive
    extends Limit {
        public Double value;

        public Exclusive(Double value) {
            this.value = value;
        }

        @Override
        public Number getValue() {
            return this.value;
        }

        @Override
        public boolean isExclusive() {
            return true;
        }

        @Override
        public boolean isInclusive() {
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        @Override
        public Integer greatestIncludedInteger() {
            return -1 + (int)Math.ceil(this.value);
        }

        @Override
        public Integer smallestIncludedInteger() {
            return 1 + (int)Math.floor(this.value);
        }
    }

    public static class ExclusiveLong
    extends Limit {
        public Long value;

        public ExclusiveLong(Long value) {
            this.value = value;
        }

        @Override
        public Number getValue() {
            return this.value;
        }

        @Override
        public boolean isExclusive() {
            return true;
        }

        @Override
        public boolean isInclusive() {
            return false;
        }

        public int hashCode() {
            return new Double(this.value.doubleValue()).hashCode();
        }

        @Override
        public Integer greatestIncludedInteger() {
            return this.value.intValue() - 1;
        }

        @Override
        public Integer smallestIncludedInteger() {
            return this.value.intValue() + 1;
        }
    }

    public static class Inclusive
    extends Limit {
        public Double value;

        public Inclusive(Double value) {
            this.value = value;
        }

        @Override
        public Number getValue() {
            return this.value;
        }

        @Override
        public boolean isExclusive() {
            return false;
        }

        @Override
        public boolean isInclusive() {
            return true;
        }

        public int hashCode() {
            return ~this.value.hashCode();
        }

        @Override
        public Integer greatestIncludedInteger() {
            return (int)Math.floor(this.value);
        }

        @Override
        public Integer smallestIncludedInteger() {
            return (int)Math.ceil(this.value);
        }
    }

    public static class InclusiveLong
    extends Limit {
        public Long value;

        public InclusiveLong(Long value) {
            this.value = value;
        }

        @Override
        public Number getValue() {
            return this.value;
        }

        @Override
        public boolean isExclusive() {
            return false;
        }

        @Override
        public boolean isInclusive() {
            return true;
        }

        public int hashCode() {
            return ~new Double(this.value.doubleValue()).hashCode();
        }

        @Override
        public Integer greatestIncludedInteger() {
            return this.value.intValue();
        }

        @Override
        public Integer smallestIncludedInteger() {
            return this.value.intValue();
        }
    }

    public static class Nolimit
    extends Limit {
        @Override
        public Number getValue() {
            return null;
        }

        @Override
        public boolean isExclusive() {
            return false;
        }

        @Override
        public boolean isInclusive() {
            return false;
        }

        @Override
        public Integer greatestIncludedInteger() {
            return null;
        }

        @Override
        public Integer smallestIncludedInteger() {
            return null;
        }
    }
}

