/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.util;

public final class IdentityPair<T1, T2> {
    public final T1 first;
    public final T2 second;
    private final int hash;

    public static <T1, T2> IdentityPair<T1, T2> make(T1 t1, T2 t2) {
        return new IdentityPair<T1, T2>(t1, t2);
    }

    public IdentityPair(T1 first, T2 second) {
        this.first = first;
        this.second = second;
        this.hash = this.makeHash();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        IdentityPair other = (IdentityPair)obj;
        return other.first == this.first && other.second == this.second || other.first == this.second && other.second == this.first;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return "<" + String.valueOf(this.first) + ", " + String.valueOf(this.second) + ">";
    }

    private int makeHash() {
        return (this.first == null ? 0 : System.identityHashCode(this.first)) + (this.second == null ? 0 : System.identityHashCode(this.second));
    }
}

