/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.util;

import java.lang.reflect.Array;

public class ArrayUtils {
    @SafeVarargs
    public static <T> T[] dropElements(T[] src, T ... elementsToDrop) {
        int n;
        if (src.length == 0) {
            return src;
        }
        int count = 0;
        T[] TArray = src;
        int n2 = src.length;
        int n3 = 0;
        while (n3 < n2) {
            block9: {
                T a = TArray[n3];
                T[] TArray2 = elementsToDrop;
                int n4 = elementsToDrop.length;
                n = 0;
                while (n < n4) {
                    T b = TArray2[n];
                    if (a != b) {
                        ++n;
                        continue;
                    }
                    break block9;
                }
                ++count;
            }
            ++n3;
        }
        if (count == src.length) {
            return src;
        }
        Class<?> componentClass = src.getClass().getComponentType();
        Object[] result = (Object[])Array.newInstance(componentClass, count);
        if (count == 0) {
            return result;
        }
        int index = 0;
        T[] TArray3 = src;
        n = src.length;
        int n5 = 0;
        while (n5 < n) {
            block10: {
                T a = TArray3[n5];
                T[] TArray4 = elementsToDrop;
                int n6 = elementsToDrop.length;
                int n7 = 0;
                while (n7 < n6) {
                    T b = TArray4[n7];
                    if (a != b) {
                        ++n7;
                        continue;
                    }
                    break block10;
                }
                result[index++] = a;
            }
            ++n5;
        }
        return result;
    }

    public static void replaceFirst(Object[] src, Object from, Object to) {
        int i = 0;
        while (i < src.length) {
            if (src[i] == from) {
                src[i] = to;
                return;
            }
            ++i;
        }
    }

    public static <T> T[] concatenate(T[] a, T[] b) {
        Class<?> compType = ArrayUtils.getCommonBase(a.getClass().getComponentType(), b.getClass().getComponentType());
        if (compType == null) {
            throw new RuntimeException("Could not deduce common array type for " + a.getClass().getName() + " and " + b.getClass().getName());
        }
        return ArrayUtils.concatenate(a, b, compType);
    }

    public static <T> T[] concatenate(T[] a, T[] b, Class<? extends T> componentType) {
        Object[] result = (Object[])Array.newInstance(componentType, a.length + b.length);
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        return result;
    }

    public static <T> T[] concatenate(T[] a, T[] b, int length) {
        Class<?> compType = ArrayUtils.getCommonBase(a.getClass().getComponentType(), b.getClass().getComponentType());
        if (compType == null) {
            throw new RuntimeException("Could not deduce common array type for " + a.getClass().getName() + " and " + b.getClass().getName());
        }
        return ArrayUtils.concatenate(a, b, length, compType);
    }

    public static <T> T[] concatenate(T[] a, T[] b, int length, Class<? extends T> componentType) {
        Object[] result = (Object[])Array.newInstance(componentType, length);
        System.arraycopy(a, 0, result, 0, Math.min(length, a.length));
        if (length > a.length) {
            System.arraycopy(b, 0, result, a.length, Math.min(b.length, length - a.length));
        }
        return result;
    }

    @SafeVarargs
    public static <T> T[] append(T[] a, T ... b) {
        return ArrayUtils.concatenate(a, b);
    }

    @SafeVarargs
    public static <T> T[] append(Class<? extends T> compType, T[] a, T ... b) {
        return ArrayUtils.concatenate(a, b, compType);
    }

    @SafeVarargs
    public static <T> T[] append(int length, T[] a, T ... b) {
        return ArrayUtils.concatenate(a, b, length);
    }

    @SafeVarargs
    public static <T> T[] append(Class<? extends T> compType, int length, T[] a, T ... b) {
        return ArrayUtils.concatenate(a, b, length, compType);
    }

    public static <T> T[] indirection(T[] source, int[] index) {
        Object[] result = (Object[])Array.newInstance(source.getClass().getComponentType(), index.length);
        int i = 0;
        while (i < index.length) {
            result[i] = source[index[i]];
            ++i;
        }
        return result;
    }

    public static <T> T[] indirection(T[] source, int[] index, int length) {
        Object[] result = (Object[])Array.newInstance(source.getClass().getComponentType(), length);
        int n = Math.min(length, index.length);
        int i = 0;
        while (i < n) {
            result[i] = source[index[i]];
            ++i;
        }
        return result;
    }

    public static Class<?> getCommonBase(Class<?> a, Class<?> b) {
        Class<?> ba;
        if (a == null || b == null) {
            return Object.class;
        }
        if (a.isArray() && b.isArray()) {
            return Array.newInstance(ArrayUtils.getCommonBase(a.getComponentType(), b.getComponentType()), 0).getClass();
        }
        if (a.isAssignableFrom(b)) {
            return a;
        }
        if (b.isAssignableFrom(a)) {
            return b;
        }
        Class<?> ab = ArrayUtils.getCommonBase(a.getSuperclass(), b);
        return ab.isAssignableFrom(ba = ArrayUtils.getCommonBase(a, b.getSuperclass())) ? ba : ab;
    }
}

