/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.units.internal.library;

import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.procedure.TObjectIntProcedure;
import gnu.trove.procedure.TObjectObjectProcedure;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.simantics.databoard.Units;
import org.simantics.databoard.file.RuntimeIOException;
import org.simantics.databoard.units.internal.UnitParseException;
import org.simantics.databoard.units.internal.library.UnitConversion;
import org.simantics.databoard.units.internal.parser.UnitParser;

public class UnitLibrary {
    final THashMap<String, UnitConversion> conversions = new THashMap();
    private static final String[] PREFIXES = new String[]{"y", "z", "a", "f", "p", "n", "\ufffd", "m", "c", "d", "da", "h", "k", "M", "G", "T", "P", "E", "Z", "Y"};
    private static final int[] PREFIX_MAGNITUDES = new int[]{-24, -21, -18, -15, -12, -9, -6, -3, -2, -1, 1, 2, 3, 6, 9, 12, 15, 18, 21, 24};

    public Set<String> getUnits() {
        return this.conversions.keySet();
    }

    public UnitConversion getConversion(String unit) {
        return (UnitConversion)this.conversions.get((Object)unit);
    }

    public static List<String> readTokens(InputStream stream) throws IOException {
        InputStreamReader reader = new InputStreamReader(stream);
        StringBuilder b = new StringBuilder();
        ArrayList<String> strings = new ArrayList<String>();
        while (true) {
            int c;
            if ((c = ((Reader)reader).read()) == -1) {
                if (b.length() <= 0) break;
                strings.add(b.toString());
                break;
            }
            if (c == 32 || c == 9 || c == 10 || c == 13) {
                if (b.length() <= 0) continue;
                strings.add(b.toString());
                b.setLength(0);
                continue;
            }
            b.append((char)c);
        }
        ((Reader)reader).close();
        return strings;
    }

    private UnitConversion parseUnit(String unit) throws UnitParseException {
        final TObjectIntHashMap exponents = new TObjectIntHashMap(4);
        final double[] scale = new double[]{1.0};
        final int[] magnitude = new int[1];
        new UnitParser(){

            @Override
            public void visit(String baseUnit, int exponent) {
                UnitConversion conversion = (UnitConversion)UnitLibrary.this.conversions.get((Object)baseUnit);
                if (conversion == null) {
                    if (exponents.adjustOrPutValue((Object)baseUnit, exponent, exponent) == 0) {
                        exponents.remove((Object)baseUnit);
                    }
                } else {
                    scale[0] = scale[0] * Math.pow(conversion.scale, exponent);
                    magnitude[0] = magnitude[0] + conversion.magnitude * exponent;
                    int i = 0;
                    while (i < conversion.baseUnits.length) {
                        String u = conversion.baseUnits[i];
                        int exp = conversion.exponents[i];
                        if (exponents.adjustOrPutValue((Object)u, exp, exp) == 0) {
                            exponents.remove((Object)u);
                        }
                        ++i;
                    }
                }
            }
        }.unit(unit, 1);
        final String[] unitArray = new String[exponents.size()];
        final int[] exponentArray = new int[exponents.size()];
        exponents.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<String>(){
            int i = 0;

            public boolean execute(String arg0, int arg1) {
                unitArray[this.i] = arg0;
                exponentArray[this.i] = arg1;
                ++this.i;
                return true;
            }
        });
        return new UnitConversion(scale[0], magnitude[0], unitArray, exponentArray);
    }

    public static UnitLibrary createDefault() {
        UnitLibrary result = new UnitLibrary();
        try {
            for (String unit : UnitLibrary.readTokens(Units.class.getResourceAsStream("baseUnits.txt"))) {
                int i = 0;
                while (i < PREFIXES.length) {
                    result.conversions.put((Object)(PREFIXES[i] + unit), (Object)new UnitConversion(1.0, PREFIX_MAGNITUDES[i], unit));
                    ++i;
                }
            }
            List<String> units = UnitLibrary.readTokens(Units.class.getResourceAsStream("scalableDerivedUnits.txt"));
            int i = 0;
            while (i < units.size()) {
                UnitConversion conversion = result.parseUnit(units.get(i + 2));
                conversion.scale *= Double.parseDouble(units.get(i + 1));
                String unit = units.get(i);
                result.conversions.put((Object)unit, (Object)conversion);
                int j = 0;
                while (j < PREFIXES.length) {
                    UnitConversion scaledConversion = new UnitConversion(conversion.scale, conversion.magnitude + PREFIX_MAGNITUDES[j], conversion.baseUnits, conversion.exponents);
                    result.conversions.put((Object)(PREFIXES[j] + unit), (Object)scaledConversion);
                    ++j;
                }
                i += 3;
            }
            units = UnitLibrary.readTokens(Units.class.getResourceAsStream("nonscalableDerivedUnits.txt"));
            i = 0;
            while (i < units.size()) {
                UnitConversion conversion = result.parseUnit(units.get(i + 2));
                conversion.scale *= Double.parseDouble(units.get(i + 1));
                result.conversions.put((Object)units.get(i), (Object)conversion);
                i += 3;
            }
            return result;
        }
        catch (UnitParseException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public static void main(String[] args) {
        UnitLibrary lib = UnitLibrary.createDefault();
        lib.conversions.forEachEntry((TObjectObjectProcedure)new TObjectObjectProcedure<String, UnitConversion>(){

            public boolean execute(String unit, UnitConversion conversion) {
                System.out.println(unit + " = " + conversion.scale + " * 10^" + conversion.magnitude + ", base=" + Arrays.toString(conversion.baseUnits));
                return true;
            }
        });
    }
}

