/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.units.internal.deprecated;

import java.util.ArrayList;
import org.simantics.databoard.units.internal.UnitParseException;
import org.simantics.databoard.units.internal.deprecated.Magnitude;
import org.simantics.databoard.units.internal.deprecated.UnitPart;
import org.simantics.databoard.units.internal.parser.UnitParser;

public class Unit {
    UnitPart[] parts;

    public Unit(UnitPart ... parts) {
        this.parts = parts;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        this.toString(b);
        return b.toString();
    }

    public void toString(StringBuilder b) {
        if (this.parts.length == 0) {
            b.append('1');
        } else {
            int i = 0;
            while (i < this.parts.length) {
                if (i > 0) {
                    b.append(".");
                }
                this.parts[i].toString(b);
                ++i;
            }
        }
    }

    public static Unit parse(String string) throws UnitParseException {
        final ArrayList parts = new ArrayList();
        UnitParser parser = new UnitParser(){

            @Override
            public void visit(String baseUnit, int exponent) {
                parts.add(new UnitPart(baseUnit, Magnitude.unscaled, exponent));
            }
        };
        parser.unit(string, 1);
        return new Unit(parts.toArray(new UnitPart[parts.size()]));
    }

    public static void main(String[] args) {
        try {
            System.out.println(Unit.parse("m2/(s3/s)"));
        }
        catch (UnitParseException e) {
            e.printStackTrace();
        }
    }
}

