/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.type;

import java.util.Set;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.NumberType;
import org.simantics.databoard.util.IdentityPair;
import org.simantics.databoard.util.Limit;
import org.simantics.databoard.util.Range;

public class LongType
extends NumberType {
    public LongType() {
    }

    public LongType(String unit) {
        this.setUnit(unit);
    }

    public LongType(String unit, Range range) {
        this.setUnit(unit);
        this.setRange(range);
    }

    public LongType(String unit, String range) {
        this.setUnit(unit);
        this.setRange(range);
    }

    public long minValue() {
        Range range = this.getRange();
        if (range == null) {
            return Long.MIN_VALUE;
        }
        Limit l = range.getLower();
        long value = l.getValue().longValue();
        if (l.isExclusive()) {
            ++value;
        }
        return value;
    }

    public long maxValue() {
        Range range = this.getRange();
        if (range == null) {
            return Long.MAX_VALUE;
        }
        Limit l = range.getUpper();
        long value = l.getValue().longValue();
        if (l.isExclusive()) {
            --value;
        }
        return value;
    }

    @Override
    public void accept(Datatype.Visitor1 v, Object obj) {
        v.visit(this, obj);
    }

    @Override
    public <T> T accept(Datatype.Visitor<T> v) {
        return v.visit(this);
    }

    @Override
    public int hashCode() {
        return 57046612 + this.metadataHashCode();
    }

    @Override
    protected boolean deepEquals(Object obj, Set<IdentityPair<Datatype, Datatype>> compareHistory) {
        if (this == obj) {
            return true;
        }
        if (!this.hasEqualMetadata(obj)) {
            return false;
        }
        return obj instanceof LongType;
    }
}

