/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.type;

import java.util.Set;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.NumberType;
import org.simantics.databoard.util.IdentityPair;
import org.simantics.databoard.util.Limit;
import org.simantics.databoard.util.Range;

public class FloatType
extends NumberType {
    public FloatType() {
    }

    public FloatType(String unit) {
        this.setUnit(unit);
    }

    public FloatType(String unit, Range range) {
        this.setUnit(unit);
        this.setRange(range);
    }

    public FloatType(String unit, String range) {
        this.setUnit(unit);
        this.setRange(range);
    }

    public float minValue() {
        Range range = this.getRange();
        if (range == null) {
            return -3.4028235E38f;
        }
        Limit l = range.getLower();
        float value = l.getValue().floatValue();
        if (l.isExclusive()) {
            value += Float.MIN_VALUE;
        }
        return value;
    }

    public float maxValue() {
        Range range = this.getRange();
        if (range == null) {
            return Float.MAX_VALUE;
        }
        Limit l = range.getUpper();
        float value = l.getValue().floatValue();
        if (l.isExclusive()) {
            value -= Float.MIN_VALUE;
        }
        return value;
    }

    @Override
    protected boolean deepEquals(Object obj, Set<IdentityPair<Datatype, Datatype>> compareHistory) {
        if (this == obj) {
            return true;
        }
        if (!this.hasEqualMetadata(obj)) {
            return false;
        }
        return obj instanceof FloatType;
    }

    @Override
    public int hashCode() {
        return 178608534 + this.metadataHashCode();
    }

    @Override
    public void accept(Datatype.Visitor1 v, Object obj) {
        v.visit(this, obj);
    }

    @Override
    public <T> T accept(Datatype.Visitor<T> v) {
        return v.visit(this);
    }
}

