/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.type;

import java.util.Set;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.NumberType;
import org.simantics.databoard.util.IdentityPair;
import org.simantics.databoard.util.Limit;
import org.simantics.databoard.util.Range;

public class DoubleType
extends NumberType {
    public DoubleType() {
    }

    public DoubleType(String unit) {
        this.setUnit(unit);
    }

    public DoubleType(String unit, Range range) {
        this.setUnit(unit);
        this.setRange(range);
    }

    public DoubleType(String unit, String range) {
        this.setUnit(unit);
        this.setRange(range);
    }

    public double minValue() {
        Range range = this.getRange();
        if (range == null) {
            return -1.7976931348623157E308;
        }
        Limit l = range.getLower();
        double value = l.getValue().doubleValue();
        if (l.isExclusive()) {
            value += Double.MIN_VALUE;
        }
        return value;
    }

    public double maxValue() {
        Range range = this.getRange();
        if (range == null) {
            return Double.MAX_VALUE;
        }
        Limit l = range.getUpper();
        double value = l.getValue().doubleValue();
        if (l.isExclusive()) {
            value -= Double.MIN_VALUE;
        }
        return value;
    }

    @Override
    protected boolean deepEquals(Object obj, Set<IdentityPair<Datatype, Datatype>> compareHistory) {
        if (this == obj) {
            return true;
        }
        if (!this.hasEqualMetadata(obj)) {
            return false;
        }
        return obj instanceof DoubleType;
    }

    @Override
    public int hashCode() {
        return 180158259 + this.metadataHashCode();
    }

    @Override
    public void accept(Datatype.Visitor1 v, Object obj) {
        v.visit(this, obj);
    }

    @Override
    public <T> T accept(Datatype.Visitor<T> v) {
        return v.visit(this);
    }
}

