/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.type;

import java.util.Set;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.NumberType;
import org.simantics.databoard.util.IdentityPair;
import org.simantics.databoard.util.Limit;
import org.simantics.databoard.util.Range;

public class ByteType
extends NumberType {
    public ByteType() {
    }

    public ByteType(String unit) {
        this.setUnit(unit);
    }

    public ByteType(String unit, String range) {
        this.setUnit(unit);
        this.setRange(range);
    }

    public ByteType(String unit, Range range) {
        this.setUnit(unit);
        this.setRange(range);
    }

    public byte minValue() {
        Range range = this.getRange();
        if (range == null) {
            return -128;
        }
        Limit l = range.getLower();
        byte value = l.getValue().byteValue();
        if (l.isExclusive()) {
            value = (byte)(value + 1);
        }
        return value;
    }

    public byte maxValue() {
        Range range = this.getRange();
        if (range == null) {
            return 127;
        }
        Limit l = range.getUpper();
        byte value = l.getValue().byteValue();
        if (l.isExclusive()) {
            value = (byte)(value - 1);
        }
        return value;
    }

    @Override
    protected boolean deepEquals(Object obj, Set<IdentityPair<Datatype, Datatype>> compareHistory) {
        if (this == obj) {
            return true;
        }
        if (!this.hasEqualMetadata(obj)) {
            return false;
        }
        return obj instanceof ByteType;
    }

    @Override
    public int hashCode() {
        return this.metadataHashCode() + 4417381;
    }

    @Override
    public void accept(Datatype.Visitor1 v, Object obj) {
        v.visit(this, obj);
    }

    @Override
    public <T> T accept(Datatype.Visitor<T> v) {
        return v.visit(this);
    }
}

