/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.streaming;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.binary.Endian;
import org.simantics.databoard.util.binary.UTF8;

public class DataReader {
    private static final Serializer DATATYPE_SERIALIZER = Bindings.getSerializerUnchecked(Bindings.getBindingUnchecked(Datatype.class));
    private final DataInput in;

    public DataReader(DataInput in) {
        this.in = in;
    }

    public DataReader(InputStream stream) {
        this.in = new DataInputStream(stream);
    }

    public boolean readBoolean() throws IOException {
        return this.in.readByte() != 0;
    }

    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    public int readInteger() throws IOException {
        return this.in.readInt();
    }

    public long readLong() throws IOException {
        return this.in.readLong();
    }

    public float readFloat() throws IOException {
        return this.in.readFloat();
    }

    public double readDouble() throws IOException {
        return this.in.readDouble();
    }

    public int readStringLength() throws IOException {
        return Endian.readDynamicUInt32(this.in);
    }

    public String readStringContent(int length) throws IOException {
        return UTF8.readModifiedUTF(this.in, length);
    }

    public String readString() throws IOException {
        int length = this.readStringLength();
        return this.readStringContent(length);
    }

    public Datatype readDatatype() throws IOException {
        return (Datatype)DATATYPE_SERIALIZER.deserialize(this.in);
    }

    public int beginVariableLengthArray() throws IOException {
        return this.in.readInt();
    }

    public int beginMap() throws IOException {
        return this.in.readInt();
    }

    public boolean beginOptional() throws IOException {
        return this.in.readByte() != 0;
    }

    public int readUnionTag(int tagCount) throws IOException {
        return Endian.getUInt(this.in, tagCount - 1);
    }

    public int readReferableRecordReference() throws IOException {
        return this.in.readInt();
    }
}

