/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.serialization.impl;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.simantics.databoard.binding.UnionBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.util.IsReferableQuery;
import org.simantics.databoard.binding.util.Result;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.util.binary.Endian;

public class UnionSerializer
extends Serializer.CompositeSerializer {
    UnionBinding binding;
    public Serializer[] componentSerializers;
    int tagTypeCount;
    Integer fixedSize;
    int minSize;

    public UnionSerializer(UnionBinding binding, Serializer[] componentSerializers) {
        super(IsReferableQuery.isReferable(binding.type()) != Result.No);
        this.tagTypeCount = binding.type().components.length;
        this.binding = binding;
        this.componentSerializers = componentSerializers;
    }

    @Override
    public void finalizeConstruction() {
        Serializer s;
        Serializer[] serializerArray = this.componentSerializers;
        int n = this.componentSerializers.length;
        int n2 = 0;
        while (n2 < n) {
            s = serializerArray[n2];
            Integer fixedSizeOfComponentSerializer = s.getConstantSize();
            if (fixedSizeOfComponentSerializer == null) {
                this.fixedSize = null;
                break;
            }
            if (this.fixedSize != null && !this.fixedSize.equals(fixedSizeOfComponentSerializer)) {
                this.fixedSize = null;
                break;
            }
            this.fixedSize = fixedSizeOfComponentSerializer;
            ++n2;
        }
        if (this.componentSerializers.length == 0) {
            this.fixedSize = 0;
        }
        if (this.fixedSize != null) {
            this.fixedSize = this.fixedSize + Endian.getUIntLength(this.tagTypeCount - 1);
        }
        if (this.componentSerializers.length > 0) {
            this.minSize = Integer.MAX_VALUE;
            serializerArray = this.componentSerializers;
            n = this.componentSerializers.length;
            n2 = 0;
            while (n2 < n) {
                s = serializerArray[n2];
                this.minSize = Math.min(this.minSize, s.getMinSize());
                ++n2;
            }
            this.minSize += Endian.getUIntLength(this.tagTypeCount - 1);
        }
    }

    @Override
    public Object deserialize(DataInput in, List<Object> identities) throws IOException {
        try {
            int tag = Endian.getUInt(in, this.tagTypeCount - 1);
            return this.binding.create(tag, this.componentSerializers[tag].deserialize(in, identities));
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Object deserializeToTry(DataInput in, List<Object> identities, Object dst) throws IOException {
        if (this.binding.isTagMutable()) {
            return this.deserialize(in, identities);
        }
        this.deserializeTo(in, identities, dst);
        return dst;
    }

    @Override
    public void deserializeTo(DataInput in, List<Object> identities, Object obj) throws IOException {
        try {
            int tag = Endian.getUInt(in, this.tagTypeCount - 1);
            int oldTag = this.binding.getTag(obj);
            Serializer cs = this.componentSerializers[tag];
            boolean csImmutable = this.binding.getComponentBinding(tag).isImmutable();
            if (oldTag == tag && !csImmutable) {
                Object component = this.binding.getValue(obj);
                component = this.componentSerializers[tag].deserializeToTry(in, identities, component);
                this.binding.setValue(obj, tag, component);
            } else {
                Object component = cs.deserialize(in, identities);
                this.binding.setValue(obj, tag, component);
            }
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void skip(DataInput in, List<Object> identities) throws IOException, SerializationException {
        int tag = Endian.getUInt(in, this.tagTypeCount - 1);
        this.componentSerializers[tag].skip(in, identities);
    }

    @Override
    public void serialize(DataOutput out, TObjectIntHashMap<Object> identities, Object obj) throws IOException {
        try {
            int tag = this.binding.getTag(obj);
            Endian.putUInt(out, tag, this.tagTypeCount - 1);
            this.componentSerializers[tag].serialize(out, identities, this.binding.getValue(obj));
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Integer getConstantSize() {
        return this.fixedSize;
    }

    @Override
    public int getSize(Object obj, TObjectIntHashMap<Object> identities) throws IOException {
        try {
            if (this.fixedSize != null) {
                return this.fixedSize;
            }
            int tag = this.binding.getTag(obj);
            return Endian.getUIntLength(this.tagTypeCount - 1) + this.componentSerializers[tag].getSize(this.binding.getValue(obj), identities);
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int getMinSize() {
        return this.minSize;
    }
}

