/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.serialization.impl;

import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.VariantBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.serialization.SerializerScheme;
import org.simantics.databoard.serialization.impl.VariantSerializer;
import org.simantics.databoard.type.Datatype;

public class MutableVariantSerializer
extends VariantSerializer {
    public MutableVariantSerializer(VariantBinding binding, SerializerScheme scheme) {
        super(binding, scheme);
    }

    @Override
    public Object deserialize(DataInput in, List<Object> identities) throws IOException {
        try {
            ArrayList<Object> typeIdentities = new ArrayList<Object>(1);
            Datatype type = (Datatype)this.datatypeSerializer.deserialize(in, typeIdentities);
            Object valueBinding = Bindings.getMutableBinding(type);
            Serializer valueSerializer = this.scheme.getSerializerUnchecked((Binding)valueBinding);
            this.assertRemainingBytes(in, valueSerializer.getMinSize());
            Object value = valueSerializer.deserialize(in, identities);
            return this.binding.create((Binding)valueBinding, value);
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void deserializeTo(DataInput in, List<Object> identities, Object obj) throws IOException {
        try {
            ArrayList<Object> typeIdentities = new ArrayList<Object>(1);
            Datatype type = (Datatype)this.datatypeSerializer.deserialize(in, typeIdentities);
            Datatype oldType = this.binding.getContentType(obj);
            if (type.equals(oldType)) {
                Binding valueBinding = this.binding.getContentBinding(obj);
                Serializer valueSerializer = this.scheme.getSerializerUnchecked(valueBinding);
                Object component = this.binding.getContent(obj);
                component = valueSerializer.deserializeToTry(in, identities, component);
                this.binding.setContent(obj, valueBinding, component);
            } else {
                Object valueBinding = Bindings.getMutableBinding(type);
                Serializer valueSerializer = this.scheme.getSerializerUnchecked((Binding)valueBinding);
                Object component = valueSerializer.deserialize(in, identities);
                this.binding.setContent(obj, (Binding)valueBinding, component);
            }
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void skip(DataInput in, List<Object> identities) throws IOException {
        ArrayList<Object> typeIdentities = new ArrayList<Object>(1);
        Datatype type = (Datatype)this.datatypeSerializer.deserialize(in, typeIdentities);
        Object valueBinding = Bindings.getMutableBinding(type);
        Serializer valueSerializer = this.scheme.getSerializerUnchecked((Binding)valueBinding);
        valueSerializer.skip(in, identities);
    }
}

