/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.serialization;

import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.BooleanBinding;
import org.simantics.databoard.binding.ByteBinding;
import org.simantics.databoard.binding.DoubleBinding;
import org.simantics.databoard.binding.FloatBinding;
import org.simantics.databoard.binding.IntegerBinding;
import org.simantics.databoard.binding.LongBinding;
import org.simantics.databoard.binding.MapBinding;
import org.simantics.databoard.binding.OptionalBinding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.StringBinding;
import org.simantics.databoard.binding.UnionBinding;
import org.simantics.databoard.binding.VariantBinding;
import org.simantics.databoard.binding.impl.BooleanArrayBinding;
import org.simantics.databoard.binding.impl.ByteArrayBinding;
import org.simantics.databoard.binding.impl.DoubleArrayBinding;
import org.simantics.databoard.binding.impl.FloatArrayBinding;
import org.simantics.databoard.binding.impl.IntArrayBinding;
import org.simantics.databoard.binding.impl.LongArrayBinding;
import org.simantics.databoard.binding.impl.StringBindingAppendable;
import org.simantics.databoard.serialization.ConcurrentSerializerFactory;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.serialization.SerializerConstructionException;
import org.simantics.databoard.serialization.SpecializedSerializerProvider;
import org.simantics.databoard.serialization.impl.AppendableModifiedUTF8StringSerializer;
import org.simantics.databoard.serialization.impl.ArraySerializer;
import org.simantics.databoard.serialization.impl.BooleanArraySerializer;
import org.simantics.databoard.serialization.impl.BooleanSerializer;
import org.simantics.databoard.serialization.impl.ByteArraySerializer;
import org.simantics.databoard.serialization.impl.ByteSerializer;
import org.simantics.databoard.serialization.impl.DoubleArraySerializer;
import org.simantics.databoard.serialization.impl.DoubleSerializer;
import org.simantics.databoard.serialization.impl.FloatArraySerializer;
import org.simantics.databoard.serialization.impl.FloatSerializer;
import org.simantics.databoard.serialization.impl.GenericRecordSerializer;
import org.simantics.databoard.serialization.impl.IntArraySerializer;
import org.simantics.databoard.serialization.impl.IntSerializer;
import org.simantics.databoard.serialization.impl.LongArraySerializer;
import org.simantics.databoard.serialization.impl.LongSerializer;
import org.simantics.databoard.serialization.impl.MapSerializer;
import org.simantics.databoard.serialization.impl.ModifiedUTF8StringSerializer;
import org.simantics.databoard.serialization.impl.MutableVariantSerializer;
import org.simantics.databoard.serialization.impl.OptionalSerializer;
import org.simantics.databoard.serialization.impl.ReferableRecordSerializer;
import org.simantics.databoard.serialization.impl.UnionSerializer;
import org.simantics.databoard.serialization.impl.VariantSerializer;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.BooleanType;
import org.simantics.databoard.type.ByteType;
import org.simantics.databoard.type.DoubleType;
import org.simantics.databoard.type.FloatType;
import org.simantics.databoard.type.IntegerType;
import org.simantics.databoard.type.LongType;

public class DefaultConcurrentSerializerFactory
extends ConcurrentSerializerFactory {
    @Override
    protected Serializer doConstruct(Binding binding) throws SerializerConstructionException {
        Binding b;
        Serializer specializedSerializer;
        if (binding instanceof SpecializedSerializerProvider && (specializedSerializer = ((SpecializedSerializerProvider)((Object)binding)).getSpecializedSerializer()) != null) {
            return specializedSerializer;
        }
        if (binding instanceof BooleanBinding) {
            return new BooleanSerializer((BooleanBinding)binding);
        }
        if (binding instanceof ByteBinding) {
            return new ByteSerializer((ByteBinding)binding);
        }
        if (binding instanceof IntegerBinding) {
            return new IntSerializer((IntegerBinding)binding);
        }
        if (binding instanceof LongBinding) {
            return new LongSerializer((LongBinding)binding);
        }
        if (binding instanceof FloatBinding) {
            return new FloatSerializer((FloatBinding)binding);
        }
        if (binding instanceof DoubleBinding) {
            return new DoubleSerializer((DoubleBinding)binding);
        }
        if (binding instanceof StringBindingAppendable) {
            return new AppendableModifiedUTF8StringSerializer((StringBinding)binding);
        }
        if (binding instanceof StringBinding) {
            return new ModifiedUTF8StringSerializer((StringBinding)binding);
        }
        if (binding instanceof RecordBinding) {
            b = (RecordBinding)binding;
            Binding[] componentBindings = ((RecordBinding)b).getComponentBindings();
            int count = ((RecordBinding)b).getComponentCount();
            if (((RecordBinding)b).type().isReferable()) {
                ReferableRecordSerializer result = new ReferableRecordSerializer((RecordBinding)b, null);
                this.addInProgress(binding, result);
                result.componentSerializers = new Serializer[count];
                int i = 0;
                while (i < count) {
                    result.componentSerializers[i] = this.construct(componentBindings[i]);
                    ++i;
                }
                result.finalizeConstruction();
                this.finishInProgress(binding);
                return result;
            }
            GenericRecordSerializer result = new GenericRecordSerializer((RecordBinding)b, null);
            this.addInProgress(binding, result);
            result.componentSerializers = new Serializer[count];
            int i = 0;
            while (i < count) {
                result.componentSerializers[i] = this.construct(componentBindings[i]);
                ++i;
            }
            result.finalizeConstruction();
            this.finishInProgress(binding);
            return result;
        }
        if (binding instanceof UnionBinding) {
            b = (UnionBinding)binding;
            Binding[] componentBindings = ((UnionBinding)b).getComponentBindings();
            int count = ((UnionBinding)b).getComponentCount();
            UnionSerializer result = new UnionSerializer((UnionBinding)b, null);
            this.addInProgress(binding, result);
            result.componentSerializers = new Serializer[count];
            int i = 0;
            while (i < count) {
                result.componentSerializers[i] = this.construct(componentBindings[i]);
                ++i;
            }
            result.finalizeConstruction();
            this.finishInProgress(binding);
            return result;
        }
        if (binding instanceof OptionalBinding) {
            b = (OptionalBinding)binding;
            OptionalSerializer result = new OptionalSerializer((OptionalBinding)b, null);
            this.addInProgress(binding, result);
            result.componentSerializer = this.construct(((OptionalBinding)b).getComponentBinding());
            this.finishInProgress(binding);
            return result;
        }
        if (binding instanceof ArrayBinding) {
            b = (ArrayBinding)binding;
            ArrayType type = ((ArrayBinding)b).type();
            if (b instanceof FloatArrayBinding && type.componentType instanceof FloatType) {
                return new FloatArraySerializer((ArrayBinding)b);
            }
            if (b instanceof DoubleArrayBinding && type.componentType instanceof DoubleType) {
                return new DoubleArraySerializer((ArrayBinding)b);
            }
            if (b instanceof IntArrayBinding && type.componentType instanceof IntegerType) {
                return new IntArraySerializer((ArrayBinding)b);
            }
            if (b instanceof ByteArrayBinding && type.componentType instanceof ByteType) {
                return new ByteArraySerializer((ArrayBinding)b);
            }
            if (b instanceof BooleanArrayBinding && type.componentType instanceof BooleanType) {
                return new BooleanArraySerializer((ArrayBinding)b);
            }
            if (b instanceof LongArrayBinding && type.componentType instanceof LongType) {
                return new LongArraySerializer((ArrayBinding)b);
            }
            ArraySerializer result = new ArraySerializer((ArrayBinding)b, null);
            this.addInProgress(binding, result);
            result.componentSerializer = this.construct(((ArrayBinding)b).getComponentBinding());
            result.finalizeConstruction();
            this.finishInProgress(binding);
            return result;
        }
        if (binding instanceof MapBinding) {
            b = (MapBinding)binding;
            MapSerializer result = new MapSerializer((MapBinding)b, null, null);
            this.addInProgress(binding, result);
            result.keySerializer = this.construct(((MapBinding)b).getKeyBinding());
            result.valueSerializer = this.construct(((MapBinding)b).getValueBinding());
            result.finalizeConstruction();
            this.finishInProgress(binding);
            return result;
        }
        if (binding instanceof VariantBinding) {
            VariantSerializer result = binding.isImmutable() ? new VariantSerializer((VariantBinding)binding, this) : new MutableVariantSerializer((VariantBinding)binding, this);
            result.finalizeConstruction();
            return result;
        }
        throw new SerializerConstructionException("Cannot serialize " + binding.getClass().getName());
    }

    @Override
    public boolean supportsBinding(Binding binding) {
        return true;
    }
}

