/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.primitives;

public abstract class UnsignedShort
extends Number
implements Comparable<Number> {
    private static final long serialVersionUID = 1L;
    public static final UnsignedShort MIN_VALUE;
    public static final UnsignedShort MAX_VALUE;
    public static final UnsignedShort ZERO;
    static long MASK;
    public static final long L_MAX_VALUE = 65535L;
    public static final long L_MIN_VALUE = 0L;
    int value;
    private static int CACHE_SIZE;
    private static Immutable[] CACHE;

    static {
        MASK = 65535L;
        CACHE_SIZE = 16;
        CACHE = new Immutable[CACHE_SIZE];
        int i = 0;
        while (i < CACHE_SIZE) {
            UnsignedShort.CACHE[i] = new Immutable(i);
            ++i;
        }
        ZERO = MIN_VALUE = CACHE[0];
        MAX_VALUE = new Immutable(65535L);
    }

    public static UnsignedShort valueOf(long value) {
        if (value >= 0L && value < (long)CACHE.length) {
            return CACHE[(int)value];
        }
        return new Immutable(value);
    }

    public static UnsignedShort fromBits(int intBits) {
        if (intBits >= 0 && intBits < CACHE.length) {
            return CACHE[intBits];
        }
        Immutable result = new Immutable();
        result.value = intBits & 0xFFFF;
        return result;
    }

    public int toBits() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value & MASK;
    }

    @Override
    public float floatValue() {
        return (long)this.value & MASK;
    }

    @Override
    public double doubleValue() {
        return (long)this.value & MASK;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UnsignedShort)) {
            return false;
        }
        UnsignedShort other = (UnsignedShort)obj;
        return this.value == other.value;
    }

    public String toString() {
        return Long.toString((long)this.value & MASK);
    }

    @Override
    public int compareTo(Number obj) {
        return Long.signum(((long)this.value & MASK) - obj.longValue());
    }

    public int hashCode() {
        return this.value;
    }

    public static class Immutable
    extends UnsignedShort {
        private static final long serialVersionUID = 1L;

        Immutable() {
        }

        public Immutable(int value) throws IllegalArgumentException {
            if ((long)value < 0L || (long)value > 65535L) {
                throw new IllegalArgumentException("Argument is not within range");
            }
            this.value = value;
        }

        public Immutable(long value) throws IllegalArgumentException {
            if (value < 0L || value > 65535L) {
                throw new IllegalArgumentException("Argument is not within range");
            }
            this.value = (int)value;
        }

        public Immutable(String stringValue) throws IllegalArgumentException {
            long value = Long.parseLong(stringValue);
            if (value < 0L || value > 65535L) {
                throw new IllegalArgumentException("Argument is not within range");
            }
            this.value = (int)value;
        }

        public static UnsignedShort fromBits(int intBits) {
            Immutable result = new Immutable();
            result.value = intBits & 0xFFFF;
            return result;
        }
    }

    public static class Mutable
    extends UnsignedShort {
        private static final long serialVersionUID = 1L;

        Mutable() {
        }

        public Mutable(int value) throws IllegalArgumentException {
            if ((long)value < 0L || (long)value > 65535L) {
                throw new IllegalArgumentException("Argument is not within range");
            }
            this.value = value;
        }

        public Mutable(long value) throws IllegalArgumentException {
            if (value < 0L || value > 65535L) {
                throw new IllegalArgumentException("Argument is not within range");
            }
            this.value = (int)value;
        }

        public Mutable(String stringValue) throws IllegalArgumentException {
            long value = Long.parseLong(stringValue);
            if (value < 0L || value > 65535L) {
                throw new IllegalArgumentException("Argument is not within range");
            }
            this.value = (int)value;
        }

        public static UnsignedShort fromBits(int intBits) {
            Mutable result = new Mutable();
            result.value = intBits & 0xFFFF;
            return result;
        }

        public void setBits(int intBits) {
            this.value = intBits;
        }

        public void setValue(int value) {
            if ((long)value < 0L || (long)value > 65535L) {
                throw new IllegalArgumentException("Argument is not within range");
            }
            this.value = value;
        }

        public void setValue(long value) {
            if (value < 0L || value > 65535L) {
                throw new IllegalArgumentException("Argument is not within range");
            }
            this.value = (int)value;
        }
    }
}

