/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.parser.ast.type.visitor;

import org.simantics.databoard.parser.ast.type.AstArrayType;
import org.simantics.databoard.parser.ast.type.AstComponent;
import org.simantics.databoard.parser.ast.type.AstRecordType;
import org.simantics.databoard.parser.ast.type.AstTupleType;
import org.simantics.databoard.parser.ast.type.AstType;
import org.simantics.databoard.parser.ast.type.AstTypeReference;
import org.simantics.databoard.parser.ast.type.AstUnionType;
import org.simantics.databoard.parser.ast.type.visitor.AstTypeVisitorVoid;

public class AstTypePrinter
implements AstTypeVisitorVoid {
    StringBuilder b = new StringBuilder();

    @Override
    public void visit(AstArrayType arrayType) {
        arrayType.componentType.accept(this);
        this.b.append("[]");
    }

    @Override
    public void visit(AstRecordType recordType) {
        this.b.append("{");
        boolean first = true;
        for (AstComponent component : recordType.components) {
            if (first) {
                first = false;
            } else {
                this.b.append(", ");
            }
            this.b.append(component.name);
            this.b.append(" : ");
            component.type.accept(this);
        }
        this.b.append("}");
    }

    @Override
    public void visit(AstTupleType tupleType) {
        this.b.append("(");
        boolean first = true;
        for (AstType component : tupleType.components) {
            if (first) {
                first = false;
            } else {
                this.b.append(", ");
            }
            component.accept(this);
        }
        this.b.append(")");
    }

    @Override
    public void visit(AstTypeReference typeReference) {
        this.b.append(typeReference.name);
        if (!typeReference.parameters.isEmpty()) {
            this.b.append("(");
            boolean first = true;
            for (AstType component : typeReference.parameters) {
                if (first) {
                    first = false;
                } else {
                    this.b.append(", ");
                }
                component.accept(this);
            }
            this.b.append(")");
        }
    }

    @Override
    public void visit(AstUnionType unionType) {
        boolean first = true;
        for (AstComponent component : unionType.components) {
            if (first) {
                first = false;
            } else {
                this.b.append(" | ");
            }
            this.b.append(component.name);
            this.b.append(' ');
            component.type.accept(this);
        }
    }

    public String toString() {
        return this.b.toString();
    }
}

