/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.method;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.method.MethodType;
import org.simantics.databoard.type.Component;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.UnionType;

public class MethodTypeDefinition
implements Comparable<MethodTypeDefinition> {
    public static Binding BINDING = Bindings.getBindingUnchecked(MethodTypeDefinition.class);
    String name;
    MethodType type;
    private transient int hash;

    public MethodTypeDefinition(String name, MethodType type) {
        this.name = name;
        this.type = type;
        this.hash = name.hashCode() + type.hashCode() * 7;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.hash = name.hashCode() + this.type.hashCode() * 7;
    }

    public MethodType getType() {
        return this.type;
    }

    public String toString() {
        Object void_ = Datatypes.getDatatypeUnchecked(Void.TYPE);
        StringBuilder sb = new StringBuilder();
        Datatype res = this.type.getResponseType();
        Datatype req = this.type.getRequestType();
        UnionType err = (UnionType)this.type.getErrorType();
        sb.append("method ");
        sb.append(this.name);
        sb.append(" : ");
        sb.append(req.toSingleLineString());
        sb.append(" -> ");
        if (res.equals(void_)) {
            sb.append("void");
        } else {
            sb.append(res.toSingleLineString());
        }
        if (err.getComponentCount() > 0) {
            sb.append(" throws ");
            int i = 0;
            while (i < err.getComponentCount()) {
                if (i > 0) {
                    sb.append(", ");
                }
                Component c = err.getComponent(i);
                sb.append(c.name);
                sb.append(c.type.toSingleLineString());
                ++i;
            }
        }
        return sb.toString();
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MethodTypeDefinition)) {
            return false;
        }
        MethodTypeDefinition other = (MethodTypeDefinition)obj;
        return other.name.equals(this.name) && other.type.equals(this.type);
    }

    @Override
    public int compareTo(MethodTypeDefinition o) {
        int c = this.name.compareTo(o.getName());
        if (c != 0) {
            return c;
        }
        c = this.type.compareTo(o.getType());
        return c;
    }
}

