/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.method;

import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.UnionBinding;
import org.simantics.databoard.method.MethodType;
import org.simantics.databoard.method.MethodTypeDefinition;

public class MethodTypeBinding {
    MethodTypeDefinition methodDefinition;
    RecordBinding requestBinding;
    Binding responseBinding;
    UnionBinding errorBinding;

    public MethodTypeBinding(String methodName, RecordBinding requestBinding, Binding responseBinding, UnionBinding errorBinding) {
        if (methodName == null || requestBinding == null || responseBinding == null || errorBinding == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.methodDefinition = new MethodTypeDefinition(methodName, new MethodType(requestBinding.type(), responseBinding.type(), errorBinding.type()));
        this.requestBinding = requestBinding;
        this.responseBinding = responseBinding;
        this.errorBinding = errorBinding;
    }

    public MethodTypeBinding(MethodTypeDefinition methodDescription, RecordBinding requestBinding, Binding responseBinding, UnionBinding errorBinding) {
        if (methodDescription == null || requestBinding == null || responseBinding == null || errorBinding == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.methodDefinition = methodDescription;
        this.requestBinding = requestBinding;
        this.responseBinding = responseBinding;
        this.errorBinding = errorBinding;
    }

    public MethodTypeDefinition getMethodDefinition() {
        return this.methodDefinition;
    }

    public MethodType getMethodType() {
        return this.methodDefinition.getType();
    }

    public String getName() {
        return this.methodDefinition.getName();
    }

    public RecordBinding getRequestBinding() {
        return this.requestBinding;
    }

    public Binding getResponseBinding() {
        return this.responseBinding;
    }

    public UnionBinding getErrorBinding() {
        return this.errorBinding;
    }
}

