/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.container;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.impl.TreeMapBinding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.container.DataContainer;
import org.simantics.databoard.container.DataFormatException;
import org.simantics.databoard.container.FormatHandler;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.binary.BinaryFile;

public class DataContainers {
    private static final Serializer STRING_SERIALIZER = Bindings.getSerializerUnchecked(Bindings.STRING);
    private static final Serializer INTEGER_SERIALIZER = Bindings.getSerializerUnchecked(Bindings.INTEGER);
    private static final Serializer METADATA_SERIALIZER = Bindings.getSerializerUnchecked(new TreeMapBinding(Bindings.STRING, Bindings.VARIANT));
    private static final Serializer DATATYPE_SERIALIZER = Bindings.getSerializerUnchecked(Datatype.class);
    private static final Serializer VARIANT_SERIALIZER = Bindings.getSerializerUnchecked(Bindings.VARIANT);
    private static final Serializer DATA_CONTAINER_SERIALIZER = Bindings.getSerializerUnchecked(DataContainer.class);

    public static String toFormatString(String formatName, int version) {
        return formatName + ":" + version;
    }

    public static DataContainer readHeader(DataInput input) throws IOException {
        String format = (String)STRING_SERIALIZER.deserialize(input);
        int version = (Integer)INTEGER_SERIALIZER.deserialize(input);
        TreeMap metadata = (TreeMap)METADATA_SERIALIZER.deserialize(input);
        return new DataContainer(format, version, metadata, null);
    }

    public static DataContainer requireHeader(DataInput input, String format, int version) {
        try {
            DataContainer header = DataContainers.readHeader(input);
            if (!format.equals(header.format) || version != header.version) {
                return header;
            }
            return null;
        }
        catch (Throwable throwable) {
            return new DataContainer("unknown", 0, null, null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DataContainer requireHeader(DataInput input, String ... requiredFormatStrings) {
        try {
            DataContainer header = DataContainers.readHeader(input);
            String formatString = DataContainers.toFormatString(header.format, header.version);
            String[] stringArray = requiredFormatStrings;
            int n = requiredFormatStrings.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return header;
                }
                String requiredFormatString = stringArray[n2];
                if (formatString.equals(requiredFormatString)) {
                    return null;
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            return new DataContainer("unknown", 0, null, null);
        }
    }

    public static DataContainer validateHeader(File file, String format, int version) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileInputStream stream = new FileInputStream(file);){
            return DataContainers.requireHeader((DataInput)new DataInputStream(stream), format, version);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static DataContainer validateHeader(File file, String ... allowedFormatStrings) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream stream = new FileInputStream(file);){
            return DataContainers.requireHeader((DataInput)new DataInputStream(stream), allowedFormatStrings);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static DataContainer readHeader(File input) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (BinaryFile rf = new BinaryFile(input, "r");){
            return DataContainers.readHeader(rf);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static DataContainer readFile(DataInput input) throws IOException {
        DataContainer result = DataContainers.readHeader(input);
        result.content = (Variant)VARIANT_SERIALIZER.deserialize(input);
        return result;
    }

    public static DataContainer readFile(DataInput input, Binding expectedBinding) throws IOException, DataFormatException {
        DataContainer result = DataContainers.readHeader(input);
        Datatype contentType = (Datatype)DATATYPE_SERIALIZER.deserialize(input);
        if (!expectedBinding.type().equals(contentType)) {
            throw new DataFormatException("Content type didn't match the type expected for the binding " + String.valueOf(expectedBinding) + ":\nexpected type: " + String.valueOf(expectedBinding.type()) + "\nactual type: " + String.valueOf(contentType));
        }
        Object value = Bindings.getSerializerUnchecked(expectedBinding).deserialize(input);
        result.content = new Variant(expectedBinding, value);
        return result;
    }

    public static <T> T readFile(DataInput input, Map<String, FormatHandler<T>> handlers) throws Exception {
        DataContainer result = DataContainers.readHeader(input);
        FormatHandler<T> handler = handlers.get(result.format + ":" + result.version);
        if (handler == null) {
            throw new DataFormatException("Unknown data format " + result.format + " version " + result.version + ".");
        }
        Binding binding = handler.getBinding();
        Datatype contentType = (Datatype)DATATYPE_SERIALIZER.deserialize(input);
        if (!binding.type().equals(contentType)) {
            throw new DataFormatException("Content type didn't match the type expected for the format " + result.format + " version " + result.version + ".");
        }
        Object value = Bindings.getSerializerUnchecked(binding).deserialize(input);
        result.content = new Variant(binding, value);
        return handler.process(result);
    }

    public static DataContainer readFile(File input) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (BinaryFile rf = new BinaryFile(input, "r");){
            return DataContainers.readFile(rf);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static DataContainer readFile(File input, Binding expectedBinding) throws IOException, DataFormatException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BinaryFile rf = new BinaryFile(input, "r");){
            return DataContainers.readFile((DataInput)rf, expectedBinding);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static <T> T readFile(File input, Map<String, FormatHandler<T>> handlers) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BinaryFile rf = new BinaryFile(input, "r");){
            return DataContainers.readFile((DataInput)rf, handlers);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void writeHeader(DataOutput output, DataContainer container) throws IOException {
        STRING_SERIALIZER.serialize(output, (Object)container.format);
        INTEGER_SERIALIZER.serialize(output, (Object)container.version);
        METADATA_SERIALIZER.serialize(output, container.metadata);
    }

    public static void writeFile(DataOutput output, DataContainer container) throws IOException {
        DataContainers.writeHeader(output, container);
        VARIANT_SERIALIZER.serialize(output, (Object)container.content);
    }

    public static void writeFile(File output, DataContainer container) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BinaryFile wf = new BinaryFile(output);){
            DataContainers.writeFile(wf, container);
            wf.setLength(wf.position());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] writeFile(DataContainer container) throws IOException {
        return DATA_CONTAINER_SERIALIZER.serialize(container);
    }
}

