/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.impl;

import java.util.UUID;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.Component;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.RecordType;

public class UUIDBinding
extends RecordBinding {
    public static final Datatype UUIDType;

    static {
        Component c1 = new Component("mostSigBits", Datatypes.LONG);
        Component c2 = new Component("leastSigBits", Datatypes.LONG);
        UUIDType = new RecordType(false, c1, c2);
    }

    public UUIDBinding() {
        this.componentBindings = new Binding[2];
        this.componentBindings[0] = Bindings.getBindingUnchecked(Long.class);
        this.componentBindings[1] = Bindings.getBindingUnchecked(Long.class);
        this.type = UUIDType;
    }

    @Override
    public Object create(Object ... value) {
        return new UUID((Long)value[0], (Long)value[1]);
    }

    @Override
    public Object getComponent(Object obj, int index) {
        UUID uuid = (UUID)obj;
        switch (index) {
            case 0: {
                return uuid.getMostSignificantBits();
            }
            case 1: {
                return uuid.getLeastSignificantBits();
            }
        }
        throw new IllegalArgumentException("index out of range, expected 0..3, got " + index);
    }

    @Override
    public Object createPartial() throws BindingException {
        return new UUID(0L, 0L);
    }

    @Override
    public void setComponents(Object obj, Object ... value) throws BindingException {
        throw new BindingException("Cannot change immutable UUID");
    }

    @Override
    public void setComponent(Object obj, int index, Object value) throws BindingException {
        throw new BindingException("Cannot change immutable UUID");
    }

    @Override
    public boolean isInstance(Object obj) {
        return obj instanceof UUID;
    }

    @Override
    public long getLong(Object r, int index) throws BindingException {
        UUID uuid = (UUID)r;
        switch (index) {
            case 0: {
                return uuid.getMostSignificantBits();
            }
            case 1: {
                return uuid.getLeastSignificantBits();
            }
        }
        throw new IllegalArgumentException("index out of range, expected 0..3, got " + index);
    }
}

