/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.impl;

import java.lang.reflect.Array;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.StringBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.UnsupportedOperationException;
import org.simantics.databoard.binding.impl.StringBindingDefault;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.StringType;
import org.simantics.databoard.util.IdentityPair;

public final class StringArrayBinding
extends ArrayBinding {
    public static StringArrayBinding createFrom(ArrayType type) {
        return new StringArrayBinding(type, new StringBindingDefault((StringType)type.componentType));
    }

    public StringArrayBinding(ArrayType type, Binding componentBinding) {
        super(type, componentBinding);
    }

    @Override
    public Object create() {
        return new String[0];
    }

    @Override
    public Object create(int length, Iterator<Object> values) {
        String[] array = new String[length];
        int i = 0;
        while (i < length) {
            array[i] = (String)values.next();
            ++i;
        }
        return array;
    }

    @Override
    public void readFrom(Binding srcBinding, Object src, Object dst) throws BindingException {
        ArrayBinding sb = (ArrayBinding)srcBinding;
        StringBinding scb = (StringBinding)sb.getComponentBinding();
        String[] d = (String[])dst;
        if (d.length != sb.size(src)) {
            throw new BindingException("String[] is length immutable");
        }
        int i = 0;
        while (i < d.length) {
            d[i] = scb.getValue(sb.get(src, i));
            ++i;
        }
    }

    public Object create(String[] array) {
        return array.clone();
    }

    @Override
    public Object create(Object[] values) {
        String[] result = new String[values.length];
        int i = 0;
        while (i < values.length) {
            result[i] = (String)values[i];
            ++i;
        }
        return result;
    }

    @Override
    public Object get(Object array, int index) throws BindingException {
        if (!this.isInstance(array)) {
            throw new BindingException("Unexpected class " + array.getClass().getSimpleName() + ", String[] expected");
        }
        return ((String[])array)[index];
    }

    @Override
    public void getAll(Object array, Object[] result) throws BindingException {
        String[] a = (String[])array;
        int i = 0;
        while (i < a.length) {
            result[i] = a[i];
            ++i;
        }
    }

    @Override
    public void set(Object array, int index, Object value) throws BindingException {
        String[] a = (String[])array;
        a[index] = (String)value;
    }

    @Override
    public int size(Object array) throws BindingException {
        if (!this.isInstance(array)) {
            throw new BindingException("Unexpected class " + array.getClass().getSimpleName() + ", String[] expected");
        }
        return ((String[])array).length;
    }

    @Override
    public boolean isInstance(Object obj) {
        return obj instanceof String[];
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    public String[] getArray(Object array) throws BindingException {
        if (!this.isInstance(array)) {
            throw new BindingException("Unexpected class " + array.getClass().getSimpleName() + ", String[] expected");
        }
        return (String[])array;
    }

    @Override
    public int deepHashValue(Object value, IdentityHashMap<Object, Object> hashedObjects) throws BindingException {
        int result = 1;
        String[] array = (String[])value;
        int i = 0;
        while (i < array.length) {
            String element = array[i];
            result = 31 * result + element.hashCode();
            ++i;
        }
        return result;
    }

    @Override
    public int deepCompare(Object o1, Object o2, Set<IdentityPair<Object, Object>> compareHistory) throws BindingException {
        String[] a1 = (String[])o1;
        int l1 = a1.length;
        String[] a2 = (String[])o2;
        int l2 = a2.length;
        int dif = l1 - l2;
        if (dif != 0) {
            return dif;
        }
        int i = 0;
        while (i < l1) {
            String v1 = a1[i];
            String v2 = a2[i];
            dif = v1.compareTo(v2);
            if (dif != 0) {
                return dif;
            }
            ++i;
        }
        return 0;
    }

    @Override
    public void add(Object array, int index, Object element) throws BindingException, IndexOutOfBoundsException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(Object array, int index, int count) throws BindingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSize(Object array, int newSize) throws BindingException {
        int oldSize = Array.getLength(array);
        if (oldSize == newSize) {
            return;
        }
        throw new BindingException("String[] is length immutable");
    }

    @Override
    public boolean isResizable() {
        return false;
    }
}

