/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.PriorityQueue;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.ArrayType;

public class PriorityQueueBinding
extends ArrayBinding {
    public PriorityQueueBinding(Binding componentBinding) {
        this(new ArrayType(componentBinding.type()), componentBinding);
    }

    public PriorityQueueBinding(ArrayType type, Binding componentBinding) {
        super(type, componentBinding);
        if (type == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.type = type;
    }

    @Override
    public Object create() {
        return new PriorityQueue<Object>(11, this.componentBinding);
    }

    @Override
    public Object create(Collection<Object> collection) throws BindingException {
        PriorityQueue<Object> result = new PriorityQueue<Object>(collection.size(), this.componentBinding);
        result.addAll(collection);
        return result;
    }

    @Override
    public Object create(int length, Iterator<Object> values) {
        PriorityQueue<Object> result = new PriorityQueue<Object>(length, this.componentBinding);
        while (values.hasNext()) {
            result.add(values.next());
        }
        return result;
    }

    @Override
    public Object create(Object[] values) {
        PriorityQueue<Object> result = new PriorityQueue<Object>(values.length, this.componentBinding);
        int i = 0;
        while (i < values.length) {
            result.add(values[i]);
            ++i;
        }
        return result;
    }

    @Override
    public Object get(Object queue, int index) throws BindingException {
        if (!this.isInstance(queue)) {
            throw new BindingException("Unexpected class " + queue.getClass().getSimpleName() + ", PriorityQueue expected");
        }
        PriorityQueue q = (PriorityQueue)queue;
        if (index < 0 || index >= q.size()) {
            throw new BindingException("Index out of bounds");
        }
        Iterator it = q.iterator();
        Object result = null;
        int i = 0;
        while (i <= index) {
            result = it.next();
            ++i;
        }
        return result;
    }

    @Override
    public void getAll(Object queue, Object[] result) throws BindingException {
        PriorityQueue q = (PriorityQueue)queue;
        int i = 0;
        Iterator it = q.iterator();
        while (it.hasNext()) {
            result[i++] = it.next();
        }
    }

    @Override
    public void set(Object array, int index, Object value) throws BindingException {
        this.remove(array, index, 1);
        this.add(array, index, value);
    }

    @Override
    public void add(Object queue, int index, Object element) throws BindingException, IndexOutOfBoundsException {
        PriorityQueue q = (PriorityQueue)queue;
        q.add(element);
    }

    @Override
    public void remove(Object queue, int index, int count) throws BindingException {
        PriorityQueue q = (PriorityQueue)queue;
        Iterator it = q.iterator();
        if (index < 0 || index >= q.size()) {
            throw new BindingException("Index out of bounds");
        }
        int i = 0;
        while (i <= index) {
            it.next();
            ++i;
        }
        it.remove();
    }

    @Override
    public int size(Object queue) throws BindingException {
        if (!this.isInstance(queue)) {
            throw new BindingException("Unexpected class " + queue.getClass().getSimpleName() + ", PriorityQueue expected");
        }
        PriorityQueue q = (PriorityQueue)queue;
        return q.size();
    }

    @Override
    public boolean isInstance(Object obj) {
        return obj instanceof PriorityQueue;
    }

    @Override
    public void setSize(Object queue, int newSize) throws BindingException {
        PriorityQueue q = (PriorityQueue)queue;
        int c = q.size() - newSize;
        int i = 0;
        while (i < c) {
            q.remove();
            ++i;
        }
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    public boolean isResizable() {
        return true;
    }
}

