/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.impl;

import java.lang.reflect.Array;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.LongBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.UnsupportedOperationException;
import org.simantics.databoard.binding.impl.LongBindingDefault;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.LongType;
import org.simantics.databoard.type.NumberType;
import org.simantics.databoard.util.IdentityPair;

public final class LongArrayBinding
extends ArrayBinding {
    public static LongArrayBinding createFrom(ArrayType type) {
        return new LongArrayBinding(type, new LongBindingDefault((LongType)type.componentType));
    }

    public LongArrayBinding(ArrayType type, Binding componentBinding) {
        super(type, componentBinding);
    }

    @Override
    public Object create() {
        return new long[0];
    }

    @Override
    public Object create(int length, Iterator<Object> values) {
        long[] array = new long[length];
        int i = 0;
        while (i < length) {
            array[i] = (Long)values.next();
            ++i;
        }
        return array;
    }

    @Override
    public Object createDefault() throws BindingException {
        NumberType nt = (NumberType)this.type().componentType;
        if (nt.getRange() == null) {
            return new long[this.type().minLength()];
        }
        return super.createDefault();
    }

    @Override
    public void readFrom(Binding srcBinding, Object src, Object dst) throws BindingException {
        ArrayBinding sb = (ArrayBinding)srcBinding;
        LongBinding scb = (LongBinding)sb.getComponentBinding();
        long[] d = (long[])dst;
        if (d.length != sb.size(src)) {
            throw new BindingException("long[] is length immutable");
        }
        int i = 0;
        while (i < d.length) {
            d[i] = scb.getValue_(sb.get(src, i));
            ++i;
        }
    }

    @Override
    public Object readFromTry(Binding srcBinding, Object src, Object dst) throws BindingException {
        ArrayBinding sb = (ArrayBinding)srcBinding;
        LongBinding scb = (LongBinding)sb.getComponentBinding();
        long[] d = (long[])dst;
        int srcSize = sb.size(src);
        if (d.length != srcSize) {
            d = new long[srcSize];
        }
        int i = 0;
        while (i < d.length) {
            d[i] = scb.getValue_(sb.get(src, i));
            ++i;
        }
        return d;
    }

    public Object create(long[] array) {
        return array.clone();
    }

    @Override
    public Object create(Object[] values) {
        long[] result = new long[values.length];
        int i = 0;
        while (i < values.length) {
            result[i] = (Long)values[i];
            ++i;
        }
        return result;
    }

    @Override
    public Object get(Object array, int index) throws BindingException {
        if (!this.isInstance(array)) {
            throw new BindingException("Unexpected class " + array.getClass().getSimpleName() + ", long[] expected");
        }
        return ((long[])array)[index];
    }

    @Override
    public void getAll(Object array, Object[] result) throws BindingException {
        long[] a = (long[])array;
        int i = 0;
        while (i < a.length) {
            result[i] = a[i];
            ++i;
        }
    }

    @Override
    public void set(Object array, int index, Object value) throws BindingException {
        long[] a = (long[])array;
        a[index] = (Long)value;
    }

    @Override
    public int size(Object array) throws BindingException {
        if (!this.isInstance(array)) {
            throw new BindingException("Unexpected class " + array.getClass().getSimpleName() + ", long[] expected");
        }
        return ((long[])array).length;
    }

    @Override
    public boolean isInstance(Object obj) {
        return obj instanceof long[];
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    public long[] getArray(Object array) throws BindingException {
        if (!this.isInstance(array)) {
            throw new BindingException("Unexpected class " + array.getClass().getSimpleName() + ", long[] expected");
        }
        return (long[])array;
    }

    @Override
    public int deepHashValue(Object value, IdentityHashMap<Object, Object> hashedObjects) throws BindingException {
        int result = 1;
        long[] array = (long[])value;
        int i = 0;
        while (i < array.length) {
            long element = array[i];
            result = 31 * result + (int)(element ^ element >>> 32);
            ++i;
        }
        return result;
    }

    @Override
    public int deepCompare(Object o1, Object o2, Set<IdentityPair<Object, Object>> compareHistory) throws BindingException {
        long[] a1 = (long[])o1;
        int l1 = a1.length;
        long[] a2 = (long[])o2;
        int l2 = a2.length;
        int dif = l1 - l2;
        if (dif != 0) {
            return dif;
        }
        int i = 0;
        while (i < l1) {
            long v1 = a1[i];
            long v2 = a2[i];
            int n = v1 < v2 ? -1 : (dif = v1 == v2 ? 0 : 1);
            if (dif != 0) {
                return dif;
            }
            ++i;
        }
        return 0;
    }

    @Override
    public void add(Object array, int index, Object element) throws BindingException, IndexOutOfBoundsException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(Object array, int index, int count) throws BindingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSize(Object array, int newSize) throws BindingException {
        int oldSize = Array.getLength(array);
        if (oldSize == newSize) {
            return;
        }
        throw new BindingException("long[] is length immutable");
    }

    @Override
    public boolean isResizable() {
        return false;
    }
}

