/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.adapter.Adapter;
import org.simantics.databoard.adapter.AdapterConstructionException;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.MapBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.MapType;

public class HashMapBinding
extends MapBinding {
    public HashMapBinding(Binding keyBinding, Binding valueBinding) {
        super(keyBinding, valueBinding);
    }

    public HashMapBinding(MapType mapType, Binding keyBinding, Binding valueBinding) {
        super(mapType, keyBinding, valueBinding);
    }

    @Override
    public Object create() {
        return new HashMap();
    }

    @Override
    public Object create(Object[] keys, Object[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Equal length arrays expected");
        }
        int len = keys.length;
        HashMap<Object, Object> result = new HashMap<Object, Object>(len);
        int i = 0;
        while (i < len) {
            Object key = keys[i];
            Object value = values[i];
            result.put(key, value);
            ++i;
        }
        return result;
    }

    @Override
    public Object create(List<Object> keys, List<Object> values) {
        if (keys.size() != values.size()) {
            throw new IllegalArgumentException("Equal length arrays expected");
        }
        int len = keys.size();
        HashMap<Object, Object> result = new HashMap<Object, Object>(len);
        int i = 0;
        while (i < len) {
            Object key = keys.get(i);
            Object value = values.get(i);
            result.put(key, value);
            ++i;
        }
        return result;
    }

    @Override
    public Object create(Map<?, ?> initialMap) throws BindingException {
        if (initialMap instanceof HashMap) {
            return initialMap;
        }
        HashMap result = new HashMap();
        this.putAll(result, initialMap);
        return result;
    }

    @Override
    public void clear(Object map) {
        ((Map)map).clear();
    }

    @Override
    public boolean containsKey(Object map, Object key) {
        Map m = (Map)map;
        Binding kb = this.getKeyBinding();
        for (Object v : m.keySet()) {
            if (!kb.equals(v, key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object map, Object value) {
        Map m = (Map)map;
        Binding vb = this.getValueBinding();
        for (Object v : m.values()) {
            if (!vb.equals(v, value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object get(Object map, Object key) {
        Map m = (Map)map;
        Binding kb = this.getKeyBinding();
        for (Map.Entry e : m.entrySet()) {
            if (!kb.equals(e.getKey(), key)) continue;
            return e.getValue();
        }
        return null;
    }

    @Override
    public Object[] getKeys(Object map) {
        Map m = (Map)map;
        Object[] result = m.keySet().toArray(new Object[m.size()]);
        Arrays.sort(result, this.getKeyBinding());
        return result;
    }

    @Override
    public void getKeys(Object map, Set<Object> keys) throws BindingException {
        Map m = (Map)map;
        keys.addAll(m.keySet());
    }

    @Override
    public int getEntries(Object src, Object from, boolean fromInclusive, Object end, boolean endInclusive, ArrayBinding dstKeyArrayBinding, Object dstKeyArray, ArrayBinding dstValueArrayBinding, Object dstValueArray, int limit) throws BindingException {
        if (this.keyBinding.compare(from, end) > 0) {
            return 0;
        }
        try {
            int dkc = dstKeyArrayBinding.size(dstKeyArray);
            int dvc = dstValueArrayBinding.size(dstValueArray);
            Adapter ka = Bindings.getTypeAdapter(this.keyBinding, dstKeyArrayBinding.getComponentBinding());
            Adapter va = Bindings.getTypeAdapter(this.valueBinding, dstValueArrayBinding.getComponentBinding());
            HashMap m = (HashMap)src;
            int i = 0;
            for (Map.Entry e : m.entrySet()) {
                boolean endMatches;
                boolean fromMatches;
                if (limit >= 0 && i >= limit) break;
                Object k = e.getKey();
                int fk = this.keyBinding.compare(from, k);
                int ek = this.keyBinding.compare(k, end);
                boolean bl = fromInclusive ? fk <= 0 : (fromMatches = fk < 0);
                boolean bl2 = endInclusive ? ek <= 0 : (endMatches = ek < 0);
                if (!fromMatches || !endMatches) continue;
                Object dk = ka.adapt(e.getKey());
                Object dv = va.adapt(e.getValue());
                if (i < dkc) {
                    dstKeyArrayBinding.set(dstKeyArray, i, dk);
                } else {
                    dstKeyArrayBinding.add(dstKeyArray, dk);
                }
                if (i < dvc) {
                    dstValueArrayBinding.set(dstValueArray, i, dv);
                } else {
                    dstValueArrayBinding.add(dstValueArray, dv);
                }
                ++i;
            }
            return i;
        }
        catch (AdapterConstructionException e) {
            throw new BindingException(e);
        }
        catch (AdaptException e) {
            throw new BindingException(e);
        }
    }

    @Override
    public int count(Object src, Object from, boolean fromInclusive, Object end, boolean endInclusive) throws BindingException {
        if (this.keyBinding.compare(from, end) > 0) {
            return 0;
        }
        int result = 0;
        HashMap m = (HashMap)src;
        for (Object k : m.keySet()) {
            boolean endMatches;
            boolean fromMatches;
            int fk = this.keyBinding.compare(from, k);
            int ek = this.keyBinding.compare(k, end);
            boolean bl = fromInclusive ? fk <= 0 : (fromMatches = fk < 0);
            boolean bl2 = endInclusive ? ek <= 0 : (endMatches = ek < 0);
            if (!fromMatches || !endMatches) continue;
            ++result;
        }
        return result;
    }

    @Override
    public Object[] getValues(Object map) {
        Map m = (Map)map;
        int len = m.size();
        Object[] keys = this.getKeys(map);
        Object[] values = new Object[len];
        int i = 0;
        while (i < len) {
            values[i] = m.get(keys[i]);
            ++i;
        }
        return values;
    }

    public void put(Object map, Object key, Object value) {
        Map m = (Map)map;
        m.put(key, value);
    }

    @Override
    public <K, V> void putAll(Object map, Map<K, V> src) throws BindingException {
        Map m = (Map)map;
        for (Map.Entry<K, V> e : src.entrySet()) {
            m.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public <K, V> void getAll(Object mapFrom, Map<K, V> to) {
        Map m = (Map)mapFrom;
        to.putAll(m);
    }

    @Override
    public void getAll(Object mapFrom, Object[] keys, Object[] values) throws BindingException {
        Map m = (Map)mapFrom;
        int len = m.size();
        if (len != keys.length) {
            throw new BindingException("Keys array is wrong size");
        }
        if (len != values.length) {
            throw new BindingException("Values array is wrong size");
        }
        Iterator iter = m.keySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            keys[i++] = iter.next();
        }
        Arrays.sort(keys, this.getKeyBinding());
        i = 0;
        while (i < len) {
            values[i] = m.get(keys[i]);
            ++i;
        }
    }

    @Override
    public Object remove(Object map, Object key) {
        Map m = (Map)map;
        Binding kb = this.getKeyBinding();
        for (Map.Entry e : m.entrySet()) {
            if (!kb.equals(e.getKey(), key)) continue;
            return m.remove(e.getKey());
        }
        return null;
    }

    @Override
    public int size(Object map) {
        Map m = (Map)map;
        return m.size();
    }

    @Override
    public boolean isInstance(Object obj) {
        return obj instanceof HashMap;
    }

    @Override
    public int deepHashValue(Object map, IdentityHashMap<Object, Object> hashedObjects) throws BindingException {
        int result = 0;
        Map m = (Map)map;
        Set s = m.entrySet();
        for (Map.Entry e : s) {
            int keyHash = this.getKeyBinding().deepHashValue(e.getKey(), hashedObjects);
            int valueHash = this.getValueBinding().deepHashValue(e.getValue(), hashedObjects);
            result += keyHash ^ valueHash;
        }
        return result;
    }

    @Override
    public Object getCeilingKey(Object map, Object key) {
        Map m = (Map)map;
        if (m.isEmpty()) {
            return null;
        }
        Binding comparator = this.getKeyBinding();
        Object pivot = null;
        for (Object o : m.keySet()) {
            int c2 = comparator.compare(key, o);
            if (c2 > 0) continue;
            if (pivot == null) {
                pivot = o;
                continue;
            }
            int c1 = comparator.compare(o, pivot);
            if (c1 >= 0) continue;
            pivot = o;
        }
        return pivot;
    }

    @Override
    public Object getFirstKey(Object map) {
        Map m = (Map)map;
        if (m.isEmpty()) {
            return null;
        }
        Binding c = this.getKeyBinding();
        Object result = null;
        for (Object o : m.keySet()) {
            if (result == null) {
                result = o;
                continue;
            }
            if (c.compare(o, result) >= 0) continue;
            result = o;
        }
        return result;
    }

    @Override
    public Object getFloorKey(Object map, Object key) {
        Map m = (Map)map;
        if (m.isEmpty()) {
            return null;
        }
        Binding comparator = this.getKeyBinding();
        Object pivot = null;
        for (Object o : m.keySet()) {
            int c2 = comparator.compare(o, key);
            if (c2 == 0) {
                return o;
            }
            if (c2 > 0) continue;
            if (pivot == null) {
                pivot = o;
                continue;
            }
            int c1 = comparator.compare(pivot, o);
            if (c1 >= 0) continue;
            pivot = o;
        }
        return pivot;
    }

    @Override
    public Object getHigherKey(Object map, Object key) {
        Map m = (Map)map;
        if (m.isEmpty()) {
            return null;
        }
        Binding comparator = this.getKeyBinding();
        Object pivot = null;
        for (Object o : m.keySet()) {
            int c2 = comparator.compare(key, o);
            if (c2 >= 0) continue;
            if (pivot == null) {
                pivot = o;
                continue;
            }
            int c1 = comparator.compare(o, pivot);
            if (c1 >= 0) continue;
            pivot = o;
        }
        return pivot;
    }

    @Override
    public Object getLastKey(Object map) {
        Map m = (Map)map;
        if (m.isEmpty()) {
            return null;
        }
        Binding c = this.getKeyBinding();
        Object result = null;
        for (Object o : m.keySet()) {
            if (result == null) {
                result = o;
                continue;
            }
            if (c.compare(o, result) <= 0) continue;
            result = o;
        }
        return result;
    }

    @Override
    public Object getLowerKey(Object map, Object key) {
        Map m = (Map)map;
        if (m.isEmpty()) {
            return null;
        }
        Binding comparator = this.getKeyBinding();
        Object pivot = null;
        for (Object o : m.keySet()) {
            int c2 = comparator.compare(o, key);
            if (c2 >= 0) continue;
            if (pivot == null) {
                pivot = o;
                continue;
            }
            int c1 = comparator.compare(pivot, o);
            if (c1 >= 0) continue;
            pivot = o;
        }
        return pivot;
    }
}

