/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.impl;

import org.simantics.databoard.binding.FloatBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.UnsupportedOperationException;
import org.simantics.databoard.type.FloatType;

public class FloatBindingDefault
extends FloatBinding {
    public FloatBindingDefault(FloatType type) {
        super(type);
    }

    @Override
    public Object create(Float value) {
        return value;
    }

    @Override
    public Object create(float value) {
        return Float.valueOf(value);
    }

    @Override
    public Object create(Number value) {
        if (value.getClass() == Float.class) {
            return value;
        }
        return Float.valueOf(value.floatValue());
    }

    @Override
    public Object create(String value) throws BindingException {
        try {
            return Float.valueOf(Float.parseFloat(value));
        }
        catch (NumberFormatException e) {
            throw new BindingException(e);
        }
    }

    @Override
    public boolean isInstance(Object obj) {
        return obj instanceof Float;
    }

    @Override
    public Float getValue(Object o) throws BindingException {
        if (o.getClass() != Float.class) {
            throw new BindingException("Unexpected class " + o.getClass().getSimpleName() + ", Float expected");
        }
        return (Float)o;
    }

    @Override
    public float getValue_(Object o) throws BindingException {
        if (o.getClass() != Float.class) {
            throw new BindingException("Unexpected class " + o.getClass().getSimpleName() + ", Float expected");
        }
        return ((Float)o).floatValue();
    }

    @Override
    public void setValue(Object obj, Number value) throws BindingException {
        throw new UnsupportedOperationException("Cannot change the value of immutable java.lang.Float");
    }

    @Override
    public void setValue(Object obj, float value) throws BindingException {
        throw new UnsupportedOperationException("Cannot change the value of immutable java.lang.Float");
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    public int compare(Object o1, Object o2) {
        Float d1 = (Float)o1;
        Float d2 = (Float)o2;
        return d1.compareTo(d2);
    }
}

