/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.impl;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.MapBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.impl.HashMapBinding;
import org.simantics.databoard.binding.impl.TreeMapBinding;
import org.simantics.databoard.type.MapType;

public class DefaultMapBinding
extends MapBinding {
    public DefaultMapBinding(Binding keyBinding, Binding valueBinding) {
        super(keyBinding, valueBinding);
    }

    public DefaultMapBinding(MapType mapType, Binding keyBinding, Binding valueBinding) {
        super(mapType, keyBinding, valueBinding);
    }

    public void postConstruction() {
    }

    @Override
    public Object create() {
        return new TreeMap(this.keyBinding);
    }

    @Override
    public Object create(Object[] keys, Object[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Equal length arrays expected");
        }
        int len = keys.length;
        TreeMap<Object, Object> result = new TreeMap<Object, Object>(this.keyBinding);
        int i = 0;
        while (i < len) {
            Object key = keys[i];
            Object value = values[i];
            result.put(key, value);
            ++i;
        }
        return result;
    }

    @Override
    public Object create(List<Object> keys, List<Object> values) {
        if (keys.size() != values.size()) {
            throw new IllegalArgumentException("Equal length arrays expected");
        }
        int len = keys.size();
        TreeMap<Object, Object> result = new TreeMap<Object, Object>(this.keyBinding);
        int i = 0;
        while (i < len) {
            Object key = keys.get(i);
            Object value = values.get(i);
            result.put(key, value);
            ++i;
        }
        return result;
    }

    @Override
    public Object create(Map<?, ?> map) {
        return map;
    }

    @Override
    public void clear(Object map) {
        ((Map)map).clear();
    }

    @Override
    public boolean containsKey(Object map, Object key) {
        Map m = (Map)map;
        return m.containsKey(key);
    }

    @Override
    public boolean containsValue(Object map, Object value) {
        Map m = (Map)map;
        Binding vb = this.getValueBinding();
        for (Object v : m.values()) {
            if (!vb.equals(v, value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object get(Object map, Object key) {
        Map m = (Map)map;
        return m.get(key);
    }

    @Override
    public Object[] getKeys(Object map) {
        Map m = (Map)map;
        return m.keySet().toArray(new Object[m.size()]);
    }

    @Override
    public void getKeys(Object map, Set<Object> keys) throws BindingException {
        Map m = (Map)map;
        keys.addAll(m.keySet());
    }

    @Override
    public int count(Object src, Object from, boolean fromInclusive, Object end, boolean endInclusive) throws BindingException {
        if (this.keyBinding.compare(from, end) > 0) {
            return 0;
        }
        if (src instanceof TreeMap) {
            TreeMap m = (TreeMap)src;
            NavigableMap sm = m.subMap(from, fromInclusive, end, endInclusive);
            return sm.size();
        }
        int result = 0;
        Map m = (Map)src;
        for (Object k : m.keySet()) {
            boolean endMatches;
            boolean fromMatches;
            int fk = this.keyBinding.compare(from, k);
            int ek = this.keyBinding.compare(k, end);
            boolean bl = fromInclusive ? fk <= 0 : (fromMatches = fk < 0);
            boolean bl2 = endInclusive ? ek <= 0 : (endMatches = ek < 0);
            if (!fromMatches || !endMatches) continue;
            ++result;
        }
        return result;
    }

    @Override
    public int getEntries(Object src, Object from, boolean fromInclusive, Object end, boolean endInclusive, ArrayBinding dstKeyArrayBinding, Object dstKeyArray, ArrayBinding dstValueArrayBinding, Object dstValueArray, int limit) throws BindingException {
        if (src instanceof TreeMap) {
            return new TreeMapBinding(this.keyBinding, this.valueBinding).getEntries(src, from, fromInclusive, end, endInclusive, dstKeyArrayBinding, dstKeyArray, dstValueArrayBinding, dstValueArray, limit);
        }
        return new HashMapBinding(this.keyBinding, this.valueBinding).getEntries(src, from, fromInclusive, end, endInclusive, dstKeyArrayBinding, dstKeyArray, dstValueArrayBinding, dstValueArray, limit);
    }

    @Override
    public Object[] getValues(Object map) {
        Map m = (Map)map;
        return m.values().toArray(new Object[m.size()]);
    }

    @Override
    public <K, V> void put(Object map, K key, V value) {
        Map m = (Map)map;
        m.put(key, value);
    }

    @Override
    public <K, V> void putAll(Object dstMap, Map<K, V> srcMap) {
        Map dst = (Map)dstMap;
        dst.putAll(srcMap);
    }

    public void getAll(Object mapFrom, Map to) {
        Map m = (Map)mapFrom;
        to.putAll(m);
    }

    @Override
    public void getAll(Object mapFrom, Object[] keys, Object[] values) {
        Map m = (Map)mapFrom;
        int i = 0;
        for (Map.Entry e : m.entrySet()) {
            keys[i] = e.getKey();
            values[i] = e.getValue();
            ++i;
        }
    }

    @Override
    public Object remove(Object map, Object key) {
        Map m = (Map)map;
        return m.remove(key);
    }

    @Override
    public int size(Object map) {
        Map m = (Map)map;
        return m.size();
    }

    @Override
    public boolean isInstance(Object obj) {
        return obj instanceof Map;
    }

    @Override
    public int deepHashValue(Object map, IdentityHashMap<Object, Object> hashedObjects) throws BindingException {
        int result = 0;
        Map m = (Map)map;
        Set s = m.entrySet();
        for (Map.Entry e : s) {
            int keyTree = this.getKeyBinding().deepHashValue(e.getKey(), hashedObjects);
            int valueTree = this.getValueBinding().deepHashValue(e.getValue(), hashedObjects);
            result += keyTree ^ valueTree;
        }
        return result;
    }

    @Override
    public Object getCeilingKey(Object map, Object key) {
        if (map instanceof TreeMap) {
            return new TreeMapBinding(this.keyBinding, this.valueBinding).getCeilingKey(map, key);
        }
        return new HashMapBinding(this.keyBinding, this.valueBinding).getCeilingKey(map, key);
    }

    @Override
    public Object getFirstKey(Object map) {
        if (map instanceof TreeMap) {
            return new TreeMapBinding(this.keyBinding, this.valueBinding).getFirstKey(map);
        }
        return new HashMapBinding(this.keyBinding, this.valueBinding).getFirstKey(map);
    }

    @Override
    public Object getFloorKey(Object map, Object key) {
        if (map instanceof TreeMap) {
            return new TreeMapBinding(this.keyBinding, this.valueBinding).getFloorKey(map, key);
        }
        return new HashMapBinding(this.keyBinding, this.valueBinding).getFloorKey(map, key);
    }

    @Override
    public Object getHigherKey(Object map, Object key) {
        if (map instanceof TreeMap) {
            return new TreeMapBinding(this.keyBinding, this.valueBinding).getHigherKey(map, key);
        }
        return new HashMapBinding(this.keyBinding, this.valueBinding).getHigherKey(map, key);
    }

    @Override
    public Object getLastKey(Object map) {
        if (map instanceof TreeMap) {
            return new TreeMapBinding(this.keyBinding, this.valueBinding).getLastKey(map);
        }
        return new HashMapBinding(this.keyBinding, this.valueBinding).getLastKey(map);
    }

    @Override
    public Object getLowerKey(Object map, Object key) {
        if (map instanceof TreeMap) {
            return new TreeMapBinding(this.keyBinding, this.valueBinding).getLowerKey(map, key);
        }
        return new HashMapBinding(this.keyBinding, this.valueBinding).getLowerKey(map, key);
    }
}

