/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.factory;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.impl.ArrayListBinding;
import org.simantics.databoard.binding.impl.BooleanArrayBinding;
import org.simantics.databoard.binding.impl.ByteArrayBinding;
import org.simantics.databoard.binding.impl.DefaultMapBinding;
import org.simantics.databoard.binding.impl.DefaultSetBinding;
import org.simantics.databoard.binding.impl.DoubleArrayBinding;
import org.simantics.databoard.binding.impl.FloatArrayBinding;
import org.simantics.databoard.binding.impl.HashMapBinding;
import org.simantics.databoard.binding.impl.HashSetBinding;
import org.simantics.databoard.binding.impl.IntArrayBinding;
import org.simantics.databoard.binding.impl.LinkedListBinding;
import org.simantics.databoard.binding.impl.LongArrayBinding;
import org.simantics.databoard.binding.impl.ObjectArrayBinding;
import org.simantics.databoard.binding.impl.PriorityQueueBinding;
import org.simantics.databoard.binding.impl.ThrowableBinding;
import org.simantics.databoard.binding.impl.TreeMapBinding;
import org.simantics.databoard.binding.impl.TreeSetBinding;
import org.simantics.databoard.binding.impl.UUIDBinding;
import org.simantics.databoard.binding.reflection.BindingProvider;
import org.simantics.databoard.binding.reflection.BindingRequest;
import org.simantics.databoard.binding.reflection.ClassBindingFactory;
import org.simantics.databoard.binding.reflection.GenericArrayBinding;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.MapType;

public class JavaUtilBindingsProvider
implements BindingProvider {
    @Override
    public Binding provideBinding(ClassBindingFactory factory, BindingRequest request) throws BindingConstructionException {
        if (UUID.class.isAssignableFrom(request.getClazz())) {
            return new UUIDBinding();
        }
        if (Throwable.class.isAssignableFrom(request.getClazz())) {
            ThrowableBinding b = new ThrowableBinding(request.getClazz());
            return b;
        }
        if (request.getClazz().isArray()) {
            Class<?> c = request.getClazz();
            if (c.equals(boolean[].class)) {
                return new BooleanArrayBinding(new ArrayType(), null);
            }
            if (c.equals(byte[].class)) {
                return new ByteArrayBinding(new ArrayType(), null);
            }
            if (c.equals(double[].class)) {
                return new DoubleArrayBinding(new ArrayType(), null);
            }
            if (c.equals(float[].class)) {
                return new FloatArrayBinding(new ArrayType(), null);
            }
            if (c.equals(int[].class)) {
                return new IntArrayBinding(new ArrayType(), null);
            }
            if (c.equals(long[].class)) {
                return new LongArrayBinding(new ArrayType(), null);
            }
            if (c.equals(Object[].class)) {
                return new ObjectArrayBinding(new ArrayType(), null);
            }
            return new GenericArrayBinding(request.getClazz(), new ArrayType(), null);
        }
        if (LinkedList.class.isAssignableFrom(request.getClazz())) {
            return new LinkedListBinding(new ArrayType(), null);
        }
        if (List.class.isAssignableFrom(request.getClazz())) {
            return new ArrayListBinding(new ArrayType(), null);
        }
        if (PriorityQueue.class.isAssignableFrom(request.getClazz())) {
            return new PriorityQueueBinding(new ArrayType(), null);
        }
        if (TreeSet.class.isAssignableFrom(request.getClazz())) {
            MapType type = new MapType();
            type.valueType = Datatypes.VOID;
            return new TreeSetBinding(type, null);
        }
        if (HashSet.class.isAssignableFrom(request.getClazz())) {
            MapType type = new MapType();
            type.valueType = Datatypes.VOID;
            return new HashSetBinding(type, null);
        }
        if (Set.class.isAssignableFrom(request.getClazz())) {
            MapType type = new MapType();
            type.valueType = Datatypes.VOID;
            return new DefaultSetBinding(type, null);
        }
        if (TreeMap.class.isAssignableFrom(request.getClazz())) {
            return new TreeMapBinding(new MapType(), null, null);
        }
        if (HashMap.class.isAssignableFrom(request.getClazz())) {
            return new HashMapBinding(new MapType(), null, null);
        }
        if (Map.class.isAssignableFrom(request.getClazz())) {
            return new DefaultMapBinding(new MapType(), null, null);
        }
        return null;
    }
}

