/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.classfactory;

import java.util.IdentityHashMap;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.BooleanType;
import org.simantics.databoard.type.ByteType;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.DoubleType;
import org.simantics.databoard.type.FloatType;
import org.simantics.databoard.type.IntegerType;
import org.simantics.databoard.type.LongType;
import org.simantics.databoard.type.MapType;
import org.simantics.databoard.type.OptionalType;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.type.StringType;
import org.simantics.databoard.type.UnionType;
import org.simantics.databoard.type.VariantType;

public class SignatureVisitor
implements Datatype.Visitor1 {
    public StringBuilder sb = new StringBuilder();
    public int hashcode = 0xBCBCBCA;
    public IdentityHashMap<Datatype, Boolean> visited = new IdentityHashMap();

    public static String toSignature(Datatype type) {
        SignatureVisitor sv = new SignatureVisitor();
        type.accept(sv, null);
        String sig = sv.sb.toString();
        return sig;
    }

    @Override
    public void visit(ArrayType b, Object obj) {
        this.sb.append('a');
        b.componentType.accept(this, obj);
        this.hashcode = 13 * this.hashcode + b.getClass().getName().hashCode() + 133 * b.metadataHashCode();
    }

    @Override
    public void visit(BooleanType b, Object obj) {
        this.sb.append('z');
        this.hashcode = 13 * this.hashcode + b.getClass().getName().hashCode() + 133 * b.metadataHashCode();
    }

    @Override
    public void visit(DoubleType b, Object obj) {
        this.sb.append('d');
        this.hashcode = 13 * this.hashcode + b.getClass().getName().hashCode() + 133 * b.metadataHashCode();
    }

    @Override
    public void visit(FloatType b, Object obj) {
        this.sb.append('f');
        this.hashcode = 13 * this.hashcode + b.getClass().getName().hashCode() + 133 * b.metadataHashCode();
    }

    @Override
    public void visit(IntegerType b, Object obj) {
        this.sb.append('i');
        this.hashcode = 13 * this.hashcode + b.getClass().getName().hashCode() + 133 * b.metadataHashCode();
    }

    @Override
    public void visit(ByteType b, Object obj) {
        this.sb.append('b');
        this.hashcode = 13 * this.hashcode + b.getClass().getName().hashCode() + 133 * b.metadataHashCode();
    }

    @Override
    public void visit(LongType b, Object obj) {
        this.sb.append('j');
        this.hashcode = 13 * this.hashcode + b.getClass().getName().hashCode() + 133 * b.metadataHashCode();
    }

    @Override
    public void visit(OptionalType b, Object obj) {
        this.sb.append('o');
        b.componentType.accept(this, this.sb);
        this.hashcode = 13 * this.hashcode + b.getClass().getName().hashCode() + 133 * b.metadataHashCode();
    }

    @Override
    public void visit(RecordType b, Object obj) {
        if (this.wasVisited(b)) {
            this.sb.append('R');
            return;
        }
        if (b.isReferable()) {
            this.sb.append('R');
            return;
        }
        this.sb.append('r');
        int i = 0;
        while (i < b.getComponentCount()) {
            b.getComponentType(i).accept(this, this.sb);
            ++i;
        }
        this.sb.append('e');
        this.hashcode = 13 * this.hashcode + b.getClass().getName().hashCode() + 133 * b.metadataHashCode();
        i = 0;
        while (i < b.getComponentCount()) {
            this.hashcode = 13 * this.hashcode + b.getComponent((int)i).name.hashCode();
            ++i;
        }
    }

    @Override
    public void visit(StringType b, Object obj) {
        this.sb.append('s');
        this.hashcode = 13 * this.hashcode + b.getClass().getName().hashCode() + 133 * b.metadataHashCode();
    }

    @Override
    public void visit(UnionType b, Object obj) {
        if (b.equals(Datatypes.getDatatypeUnchecked(Datatype.class))) {
            this.sb.append("t");
            return;
        }
        if (this.wasVisited(b)) {
            this.sb.append('U');
            return;
        }
        this.sb.append('u');
        int i = 0;
        while (i < b.getComponentCount()) {
            b.getComponentType(i).accept(this, this.sb);
            ++i;
        }
        this.sb.append('e');
        this.hashcode = 13 * this.hashcode + b.getClass().getName().hashCode() + 133 * b.metadataHashCode();
    }

    @Override
    public void visit(VariantType b, Object obj) {
        this.sb.append('v');
        this.hashcode = 13 * this.hashcode + b.getClass().getName().hashCode() + 133 * b.metadataHashCode();
    }

    @Override
    public void visit(MapType b, Object obj) {
        if (this.wasVisited(b)) {
            return;
        }
        this.sb.append('m');
        b.keyType.accept(this, obj);
        b.valueType.accept(this, obj);
        this.hashcode = 13 * this.hashcode + b.getClass().getName().hashCode() + 133 * b.metadataHashCode();
    }

    boolean wasVisited(Datatype type) {
        Boolean result = this.visited.put(type, Boolean.TRUE);
        return result == null ? false : result;
    }
}

