/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding;

import java.util.IdentityHashMap;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.IndexReference;
import org.simantics.databoard.accessor.reference.KeyReference;
import org.simantics.databoard.accessor.reference.LabelReference;
import org.simantics.databoard.accessor.reference.NameReference;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.RuntimeBindingException;
import org.simantics.databoard.binding.impl.BindingPrintContext;
import org.simantics.databoard.type.OptionalType;
import org.simantics.databoard.util.IdentityPair;

public abstract class OptionalBinding
extends Binding {
    public Binding componentBinding;

    public OptionalBinding(OptionalType type, Binding componentBinding) {
        this.componentBinding = componentBinding;
        this.type = type;
    }

    public OptionalBinding(Binding componentBinding) {
        this.componentBinding = componentBinding;
        this.type = new OptionalType(componentBinding.type());
    }

    @Override
    public OptionalType type() {
        return (OptionalType)this.type;
    }

    public abstract Object createNoValue() throws BindingException;

    public abstract Object createValue(Object var1) throws BindingException;

    public abstract boolean hasValue(Object var1) throws BindingException;

    public abstract Object getValue(Object var1) throws BindingException;

    public abstract void setValue(Object var1, Object var2) throws BindingException;

    public abstract void setNoValue(Object var1) throws BindingException;

    @Override
    public abstract boolean isInstance(Object var1);

    public Binding getComponentBinding() {
        return this.componentBinding;
    }

    @Override
    public void readFrom(Binding srcBinding, Object src, Object dst) throws BindingException {
        OptionalBinding sb = (OptionalBinding)srcBinding;
        if (sb.hasValue(src)) {
            Binding dcb = this.getComponentBinding();
            Binding scb = sb.getComponentBinding();
            Object scv = sb.getValue(src);
            if (dcb.isImmutable() || !this.hasValue(dst)) {
                try {
                    Object v = Bindings.clone(scv, scb, dcb);
                    v = dcb.readFromTry(scb, scv, v);
                    this.setValue(dst, v);
                }
                catch (AdaptException e) {
                    throw new BindingException(e);
                }
            } else {
                Object v = this.getValue(src);
                v = dcb.readFromTry(scb, scv, v);
                this.setValue(dst, v);
            }
        } else {
            this.setNoValue(dst);
        }
    }

    @Override
    public void accept(Binding.Visitor1 v, Object obj) {
        v.visit(this, obj);
    }

    @Override
    public <T> T accept(Binding.Visitor<T> v) {
        return v.visit(this);
    }

    @Override
    public void assertInstaceIsValid(Object obj, Set<Object> validInstances) throws BindingException {
        if (!this.hasValue(obj)) {
            return;
        }
        Object componentValue = this.getValue(obj);
        this.componentBinding.assertInstaceIsValid(componentValue, validInstances);
    }

    @Override
    public int deepHashValue(Object value, IdentityHashMap<Object, Object> hashedObjects) throws BindingException {
        return this.hasValue(value) ? this.componentBinding.deepHashValue(this.getValue(value), hashedObjects) : 0;
    }

    @Override
    public int deepCompare(Object o1, Object o2, Set<IdentityPair<Object, Object>> compareHistory) throws BindingException {
        Boolean h1 = this.hasValue(o1);
        Boolean h2 = this.hasValue(o2);
        if (!h1.booleanValue() && !h2.booleanValue()) {
            return 0;
        }
        int dif = h1.compareTo(h2);
        if (dif != 0) {
            return dif;
        }
        Binding c = this.getComponentBinding();
        Object v1 = this.getValue(o1);
        Object v2 = this.getValue(o2);
        return c.deepCompare(v1, v2, compareHistory);
    }

    public Object createNoValueUnchecked() throws RuntimeBindingException {
        try {
            return this.createNoValue();
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
    }

    public Object createValueUnchecked(Object value) throws RuntimeBindingException {
        try {
            return this.createValue(value);
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
    }

    public boolean hasValueUnchecked(Object arg) throws RuntimeBindingException {
        try {
            return this.hasValue(arg);
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
    }

    @Override
    protected void toString(Object value, BindingPrintContext ctx) throws BindingException {
        if (this.hasValue(value)) {
            this.getComponentBinding().toString(this.getValue(value), ctx);
        } else {
            ctx.b.append("null");
        }
    }

    @Override
    public Binding getComponentBinding(ChildReference path) {
        if (path == null) {
            return this;
        }
        if (path instanceof KeyReference) {
            throw new IllegalArgumentException("KeyReference is not supported in OptionalType");
        }
        if (path instanceof NameReference) {
            throw new IllegalArgumentException("NameReference is not supported in OptionalType");
        }
        if (path instanceof IndexReference && ((IndexReference)path).index != 0) {
            throw new IllegalArgumentException("Index out of bounds");
        }
        if (path instanceof LabelReference && !((LabelReference)path).label.equals("v")) {
            throw new IllegalArgumentException("Unknown label");
        }
        return this.componentBinding.getComponentBinding(path.childReference);
    }

    @Override
    public int getComponentCount() {
        return 1;
    }

    @Override
    public Binding getComponentBinding(int index) {
        if (index == 0) {
            return this.componentBinding;
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected boolean deepEquals(Object obj, Set<IdentityPair<Binding, Binding>> compareHistory) {
        return super.deepEquals(obj, compareHistory) && this.componentBinding.equals((Object)((OptionalBinding)obj).componentBinding, compareHistory);
    }

    @Override
    public int deepHashCode(IdentityHashMap<Object, Object> hashedObjects) {
        return super.deepHashCode(hashedObjects) + this.componentBinding.hashCode(hashedObjects);
    }
}

