/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.simantics.databoard.annotations.Arguments;

public class ArgumentImpl
implements Arguments {
    int hash;
    Class<?>[] args;

    public ArgumentImpl(Class<?> ... args) {
        this.hash = Arrays.hashCode(args);
        this.args = args;
    }

    public static Arguments dropArguments(Arguments src, int count) {
        if (src == null) {
            return null;
        }
        int newLen = src.value().length - count;
        if (newLen <= 0) {
            return null;
        }
        Class[] newList = (Class[])Array.newInstance(Class.class, newLen);
        System.arraycopy(src.value(), count, newList, 0, newLen);
        return new ArgumentImpl(newList);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return Arguments.class;
    }

    @Override
    public Class<?>[] value() {
        return this.args;
    }

    @Override
    public int hashCode() {
        return this.hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Arguments)) {
            return false;
        }
        Arguments other = (Arguments)obj;
        Object[] classArray1 = this.args;
        Object[] classArray2 = other.value();
        return Arrays.deepEquals(classArray1, classArray2);
    }
}

