/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.accessor.reference;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.adapter.Adapter;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.util.URIUtil;

public class KeyReference
extends ChildReference {
    static Adapter VARIANT_TO_STRING_ADAPTER = Bindings.getAdapterUnchecked(Bindings.VARIANT, Bindings.STR_VARIANT);
    public Variant key;

    public KeyReference() {
    }

    public KeyReference(Binding keyBinding, Object key) {
        this.key = new Variant(keyBinding, key);
    }

    public KeyReference(Variant key) {
        this.key = key.clone();
    }

    public KeyReference(Variant key, ChildReference child) {
        super(child);
        this.key = key.clone();
    }

    @Override
    public String toString(boolean labelReference) {
        String strKey = (String)VARIANT_TO_STRING_ADAPTER.adaptUnchecked(this.key);
        return labelReference ? URIUtil.encodeURI(strKey) : "k-" + strKey;
    }

    @Override
    public ChildReference clone() {
        return new KeyReference(this.key.clone(), this.childReference == null ? null : this.childReference.clone());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KeyReference)) {
            return false;
        }
        KeyReference other = (KeyReference)obj;
        if (!other.key.equals(this.key)) {
            return false;
        }
        if (other.hasChildReference() != this.hasChildReference()) {
            return false;
        }
        return !this.hasChildReference() || other.childReference.equals(this.childReference);
    }

    public int hashCode() {
        int hash = 61468996 + 37 * this.key.hashCode();
        if (this.hasChildReference()) {
            hash = 31 * hash + this.childReference.hashCode();
        }
        return hash;
    }

    @Override
    public String toString() {
        return "[" + String.valueOf(this.key) + "]";
    }
}

