/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.accessor.reference;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.reference.ComponentReference;
import org.simantics.databoard.accessor.reference.IndexReference;
import org.simantics.databoard.accessor.reference.KeyReference;
import org.simantics.databoard.accessor.reference.LabelReference;
import org.simantics.databoard.accessor.reference.NameReference;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.annotations.Optional;
import org.simantics.databoard.annotations.Union;
import org.simantics.databoard.binding.mutable.MutableVariant;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.MapType;
import org.simantics.databoard.type.OptionalType;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.type.UnionType;
import org.simantics.databoard.util.URIUtil;

@Union(value={IndexReference.class, KeyReference.class, NameReference.class, ComponentReference.class, LabelReference.class})
public abstract class ChildReference
implements Cloneable {
    public static final Pattern INDEX_PATTERN = Pattern.compile("i-(\\d*)");
    public static final Pattern MAP_PATTERN = Pattern.compile("k-(\\p{ASCII}*)");
    public static final Pattern NAME_PATTERN = Pattern.compile("n-(\\p{ASCII}*)");
    @Optional
    public ChildReference childReference;

    public static ChildReference concatenate(ChildReference pathToBeCloned, ChildReference ref) {
        if (pathToBeCloned == null) {
            return ref;
        }
        ChildReference result = pathToBeCloned.clone();
        if (ref == null) {
            return result;
        }
        result.tail().setChildReference(ref);
        return result;
    }

    public static ChildReference compile(ChildReference ... refs) {
        ChildReference first;
        if (refs.length == 0) {
            return null;
        }
        ChildReference r = first = refs[0].clone();
        int i = 1;
        while (i < refs.length) {
            ChildReference next = refs[i].clone();
            r.setChildReference(next);
            r = next;
            while (r.childReference != null) {
                r = r.childReference;
            }
            ++i;
        }
        return first;
    }

    public static ChildReference compile(Collection<ChildReference> refs) {
        ChildReference first;
        if (refs.isEmpty()) {
            return null;
        }
        Iterator<ChildReference> itr = refs.iterator();
        ChildReference r = first = itr.next().clone();
        while (itr.hasNext()) {
            ChildReference next = itr.next().clone();
            r.setChildReference(next);
            r = next;
            while (r.childReference != null) {
                r = r.childReference;
            }
        }
        return first;
    }

    public static ChildReference parsePath(String path) {
        ChildReference first;
        StringTokenizer st = new StringTokenizer(path, "/", false);
        if (!st.hasMoreTokens()) {
            return null;
        }
        ChildReference ref = first = ChildReference.createSingleReference(st.nextToken());
        while (st.hasMoreTokens()) {
            ref = ref.childReference = ChildReference.createSingleReference(st.nextToken());
        }
        return first;
    }

    public static ChildReference toTypeReference(ChildReference vref, Datatype type) throws IllegalArgumentException {
        if (vref == null) {
            return null;
        }
        if (type instanceof ArrayType && (vref instanceof IndexReference || vref instanceof LabelReference)) {
            ChildReference tail = ChildReference.toTypeReference(vref.childReference, type.getComponentType(0));
            return new ComponentReference(tail);
        }
        if (type instanceof MapType && vref instanceof KeyReference) {
            ChildReference tail = ChildReference.toTypeReference(vref.childReference, type.getComponentType(1));
            return new IndexReference(1, tail);
        }
        if (type instanceof OptionalType) {
            if (vref instanceof ComponentReference) {
                ChildReference tail = ChildReference.toTypeReference(vref.childReference, type.getComponentType(0));
                return new ComponentReference(tail);
            }
            if (vref instanceof LabelReference) {
                LabelReference lr = (LabelReference)vref;
                if (lr.label.equals("v")) {
                    ChildReference tail = ChildReference.toTypeReference(vref.childReference, type.getComponentType(0));
                    return new ComponentReference(tail);
                }
            }
        }
        if (type instanceof RecordType) {
            RecordType rt = (RecordType)type;
            if (vref instanceof IndexReference) {
                IndexReference ir = (IndexReference)vref;
                ChildReference tail = ChildReference.toTypeReference(vref.childReference, type.getComponentType(ir.index));
                return new IndexReference(ir.index, tail);
            }
            if (vref instanceof NameReference) {
                NameReference ir = (NameReference)vref;
                ChildReference tail = ChildReference.toTypeReference(vref.childReference, rt.getComponentType(ir.name));
                return new NameReference(ir.name, tail);
            }
            if (vref instanceof LabelReference) {
                LabelReference ir = (LabelReference)vref;
                ChildReference tail = ChildReference.toTypeReference(vref.childReference, rt.getComponentType(ir.label));
                return new NameReference(ir.label, tail);
            }
        }
        if (type instanceof UnionType) {
            UnionType ut = (UnionType)type;
            if (vref instanceof IndexReference) {
                IndexReference ir = (IndexReference)vref;
                ChildReference tail = ChildReference.toTypeReference(vref.childReference, type.getComponentType(ir.index));
                return new IndexReference(ir.index, tail);
            }
            if (vref instanceof NameReference) {
                NameReference ir = (NameReference)vref;
                ChildReference tail = ChildReference.toTypeReference(vref.childReference, ut.getComponentType(ir.name));
                return new NameReference(ir.name, tail);
            }
            if (vref instanceof LabelReference) {
                LabelReference ir = (LabelReference)vref;
                ChildReference tail = ChildReference.toTypeReference(vref.childReference, ut.getComponentType(ir.label));
                return new NameReference(ir.label, tail);
            }
        }
        throw new IllegalArgumentException();
    }

    public static ChildReference parseBinary(byte[] binaryRef) throws IOException {
        Object binding = Bindings.getBindingUnchecked(ChildReference.class);
        ChildReference result = (ChildReference)Bindings.getSerializerUnchecked(binding).deserialize(binaryRef);
        return result;
    }

    protected ChildReference() {
    }

    protected ChildReference(ChildReference childReference) {
        this.childReference = childReference;
    }

    public ChildReference getChildReference() {
        return this.childReference;
    }

    public boolean hasChildReference() {
        return this.childReference != null;
    }

    public void setChildReference(ChildReference childReference) {
        this.childReference = childReference;
    }

    public int getDepth() {
        int result = 1;
        ChildReference r = this;
        while (r.childReference != null) {
            r = r.childReference;
            ++result;
        }
        return result;
    }

    public String toPath() {
        return this.toPath(true);
    }

    public String toPath(boolean labelReference) {
        if (this.childReference == null) {
            return this.toString();
        }
        StringBuilder sb = new StringBuilder();
        ChildReference ref = this;
        while (ref != null) {
            if (sb.length() > 0) {
                sb.append("/");
            }
            sb.append(ref.toString(labelReference));
            ref = ref.getChildReference();
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(true);
    }

    public abstract String toString(boolean var1);

    public abstract ChildReference clone();

    public ChildReference tail() {
        ChildReference result = this;
        while (result.childReference != null) {
            result = result.childReference;
        }
        return result;
    }

    static ChildReference createSingleReference(String ref) {
        Matcher m = INDEX_PATTERN.matcher(ref);
        if (m.matches()) {
            return new IndexReference(Integer.parseInt(m.group(1)));
        }
        m = MAP_PATTERN.matcher(ref);
        if (m.matches()) {
            MutableVariant key;
            String keyStr = m.group(1);
            try {
                key = (MutableVariant)Bindings.adapt(keyStr, Bindings.STRING, Bindings.MUTABLE_VARIANT);
            }
            catch (AdaptException e) {
                throw new IllegalArgumentException("Not string variant " + ref, e);
            }
            return new KeyReference(key);
        }
        m = NAME_PATTERN.matcher(ref);
        if (m.matches()) {
            String encoded = m.group(1);
            String name = URIUtil.decodeURI(encoded);
            return new NameReference(name);
        }
        if (ref.equals("v")) {
            return new ComponentReference();
        }
        String text = URIUtil.decodeURI(ref);
        return new LabelReference(text);
    }
}

