/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.accessor.java;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.accessor.ParametrisedAccessor;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.error.ReferenceException;
import org.simantics.databoard.accessor.event.Event;
import org.simantics.databoard.accessor.event.InvalidatedEvent;
import org.simantics.databoard.accessor.event.ValueAssigned;
import org.simantics.databoard.accessor.impl.AccessorParams;
import org.simantics.databoard.accessor.impl.ListenerEntry;
import org.simantics.databoard.accessor.interestset.ByteInterestSet;
import org.simantics.databoard.accessor.interestset.InterestSet;
import org.simantics.databoard.accessor.java.JavaArray;
import org.simantics.databoard.accessor.java.JavaBoolean;
import org.simantics.databoard.accessor.java.JavaByte;
import org.simantics.databoard.accessor.java.JavaDouble;
import org.simantics.databoard.accessor.java.JavaFloat;
import org.simantics.databoard.accessor.java.JavaInteger;
import org.simantics.databoard.accessor.java.JavaLong;
import org.simantics.databoard.accessor.java.JavaMap;
import org.simantics.databoard.accessor.java.JavaOptional;
import org.simantics.databoard.accessor.java.JavaRecord;
import org.simantics.databoard.accessor.java.JavaString;
import org.simantics.databoard.accessor.java.JavaUnion;
import org.simantics.databoard.accessor.java.JavaVariant;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.adapter.AdapterConstructionException;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.BooleanBinding;
import org.simantics.databoard.binding.ByteBinding;
import org.simantics.databoard.binding.DoubleBinding;
import org.simantics.databoard.binding.FloatBinding;
import org.simantics.databoard.binding.IntegerBinding;
import org.simantics.databoard.binding.LongBinding;
import org.simantics.databoard.binding.MapBinding;
import org.simantics.databoard.binding.OptionalBinding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.StringBinding;
import org.simantics.databoard.binding.UnionBinding;
import org.simantics.databoard.binding.VariantBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.Datatype;

public abstract class JavaObject
implements Accessor,
ParametrisedAccessor {
    Accessor parent;
    Object object;
    Binding binding;
    ListenerEntry listeners = null;
    Object keyInParent = null;
    AccessorParams params;

    public JavaObject(Accessor parent, Binding binding, Object initialValue, AccessorParams params) {
        if (binding == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.parent = parent;
        this.binding = binding;
        this.object = initialValue;
        this.params = params;
    }

    public Object getObject() {
        return this.object;
    }

    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public AccessorParams getParams() {
        return this.params;
    }

    @Override
    public Datatype type() {
        return this.binding.type();
    }

    public Lock getReadLock() {
        return this.params.readLock;
    }

    public Lock getWriteLock() {
        return this.params.writeLock;
    }

    protected void readLock() {
        if (this.params.readLock != null) {
            this.params.readLock.lock();
        }
    }

    protected void readUnlock() {
        if (this.params.readLock != null) {
            this.params.readLock.unlock();
        }
    }

    protected void writeLock() {
        if (this.params.writeLock != null) {
            this.params.writeLock.lock();
        }
    }

    protected void writeUnlock() {
        if (this.params.writeLock != null) {
            this.params.writeLock.unlock();
        }
    }

    @Override
    public Object getValue(Binding binding) throws AccessorException {
        this.readLock();
        try {
            if (binding == this.binding) {
                Object object = binding.isImmutable() ? this.object : binding.clone(this.object);
                return object;
            }
            Object object = this.adapt(this.object, this.binding, binding);
            return object;
        }
        catch (AdaptException e) {
            throw new AccessorException(e);
        }
        catch (AdapterConstructionException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public void getValue(Binding binding, Object obj) throws AccessorException {
        this.readLock();
        try {
            try {
                this.binding.readFrom(this.binding, this.object, obj);
            }
            catch (BindingException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.readLock();
        }
    }

    @Override
    public boolean getValue(ChildReference path, Binding binding, Object obj) throws AccessorException {
        try {
            Object a = this.getComponent(path);
            a.getValue(binding, obj);
            return true;
        }
        catch (ReferenceException referenceException) {
            return false;
        }
        catch (AccessorConstructionException e) {
            throw new AccessorException(e);
        }
    }

    @Override
    public Object getValue(ChildReference path, Binding binding) throws AccessorException {
        try {
            Object a = this.getComponent(path);
            return a.getValue(binding);
        }
        catch (ReferenceException referenceException) {
            return null;
        }
        catch (AccessorConstructionException e) {
            throw new AccessorException(e);
        }
    }

    @Override
    public boolean setValue(ChildReference path, Binding binding, Object obj) throws AccessorException {
        try {
            Object a = this.getComponent(path);
            a.setValue(binding, obj);
            return true;
        }
        catch (ReferenceException referenceException) {
            return false;
        }
        catch (AccessorConstructionException e) {
            throw new AccessorException(e);
        }
    }

    Object adapt(Object value, Binding domain, Binding range) throws AdaptException, AdapterConstructionException {
        return this.params.adapterScheme.getAdapter(domain, range, true, false).adapt(value);
    }

    @Override
    public void addListener(Accessor.Listener listener, InterestSet interestSet, ChildReference path, Executor executor) throws AccessorException {
        this.listeners = ListenerEntry.link(this.listeners, listener, interestSet, path, executor);
    }

    protected ListenerEntry detachListener(Accessor.Listener listener) throws AccessorException {
        ListenerEntry e = this.listeners;
        ListenerEntry p = null;
        while (e != null) {
            if (e.listener == listener) {
                if (p == null) {
                    this.listeners = e.next;
                    return e;
                }
                p.next = e.next;
                return e;
            }
            p = e;
            e = e.next;
        }
        return null;
    }

    @Override
    public void removeListener(Accessor.Listener listener) throws AccessorException {
        this.detachListener(listener);
    }

    public static JavaObject createAccessor(Accessor parent, Binding b, Object v, AccessorParams params) throws AccessorConstructionException {
        return JavaObject.createSubAccessor(parent, b, v, params);
    }

    public static JavaObject createSubAccessor(Accessor parent, Binding b, Object v, AccessorParams params) throws AccessorConstructionException {
        if (b instanceof BooleanBinding) {
            return new JavaBoolean(parent, (BooleanBinding)b, v, params);
        }
        if (b instanceof ByteBinding) {
            return new JavaByte(parent, (ByteBinding)b, v, params);
        }
        if (b instanceof IntegerBinding) {
            return new JavaInteger(parent, (IntegerBinding)b, v, params);
        }
        if (b instanceof LongBinding) {
            return new JavaLong(parent, (LongBinding)b, v, params);
        }
        if (b instanceof FloatBinding) {
            return new JavaFloat(parent, (FloatBinding)b, v, params);
        }
        if (b instanceof DoubleBinding) {
            return new JavaDouble(parent, (DoubleBinding)b, v, params);
        }
        if (b instanceof StringBinding) {
            return new JavaString(parent, (StringBinding)b, v, params);
        }
        if (b instanceof UnionBinding) {
            return new JavaUnion(parent, (UnionBinding)b, v, params);
        }
        if (b instanceof OptionalBinding) {
            return new JavaOptional(parent, (OptionalBinding)b, v, params);
        }
        if (b instanceof VariantBinding) {
            return new JavaVariant(parent, (VariantBinding)b, v, params);
        }
        if (b instanceof ArrayBinding) {
            return new JavaArray(parent, (ArrayBinding)b, v, params);
        }
        if (b instanceof MapBinding) {
            return new JavaMap(parent, (MapBinding)b, v, params);
        }
        if (b instanceof RecordBinding) {
            return new JavaRecord(parent, (RecordBinding)b, v, params);
        }
        throw new AccessorConstructionException("Can not create accessor to " + String.valueOf(b.type()));
    }

    void invalidatedNotification() {
        ListenerEntry le = this.listeners;
        while (le != null) {
            Object is = le.getInterestSet();
            if (((InterestSet)is).inNotifications()) {
                InvalidatedEvent e = new InvalidatedEvent();
                this.emitEvent(le, e);
            }
            le = le.next;
        }
    }

    abstract Event applyLocal(Event var1, boolean var2) throws AccessorException;

    @Override
    public void apply(List<Event> cs, LinkedList<Event> rollback) throws AccessorException {
        this.writeLock();
        try {
            try {
                boolean makeRollback = rollback != null;
                for (Event e : cs) {
                    JavaObject a = e.reference == null ? this : (JavaObject)this.getComponent(e.reference);
                    Event rbe = a.applyLocal(e, makeRollback);
                    if (!makeRollback) continue;
                    rbe.reference = e.reference;
                    rollback.addFirst(rbe);
                }
            }
            catch (AccessorConstructionException ae) {
                throw new AccessorException(ae);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    public String toString() {
        try {
            return "Java(" + this.binding.printValueDefinition(this.object, true) + ")";
        }
        catch (IOException e) {
            return "Java(error=" + e.getMessage() + ")";
        }
        catch (BindingException e) {
            return "Java(error=" + e.getMessage() + ")";
        }
    }

    public void notifyValueChanged() {
        ListenerEntry le = this.listeners;
        while (le != null) {
            ByteInterestSet is = (ByteInterestSet)le.getInterestSet();
            if (is.inNotifications()) {
                ValueAssigned e = new ValueAssigned(this.binding, this.object);
                this.emitEvent(le, e);
            }
            le = le.next;
        }
    }

    protected void emitEvent(ListenerEntry le, Event e) {
        e.reference = ChildReference.concatenate(le.path, e.reference);
        le.emitEvent(e);
    }

    protected void emitEvents(ListenerEntry le, Collection<Event> events) {
        for (Event e : events) {
            e.reference = ChildReference.concatenate(le.path, e.reference);
        }
        le.emitEvents(events);
    }
}

