/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.accessor.java;

import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.accessor.MapAccessor;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.error.ReferenceException;
import org.simantics.databoard.accessor.event.Event;
import org.simantics.databoard.accessor.event.MapEntryAdded;
import org.simantics.databoard.accessor.event.MapEntryRemoved;
import org.simantics.databoard.accessor.event.ModificationEvent;
import org.simantics.databoard.accessor.event.ValueAssigned;
import org.simantics.databoard.accessor.impl.AccessorParams;
import org.simantics.databoard.accessor.impl.ListenerEntry;
import org.simantics.databoard.accessor.interestset.InterestSet;
import org.simantics.databoard.accessor.interestset.MapInterestSet;
import org.simantics.databoard.accessor.java.JavaObject;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.KeyReference;
import org.simantics.databoard.accessor.reference.LabelReference;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.adapter.Adapter;
import org.simantics.databoard.adapter.AdapterConstructionException;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.MapBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.MutableVariant;
import org.simantics.databoard.type.MapType;

public class JavaMap
extends JavaObject
implements MapAccessor {
    TreeMap<Object, SoftReference<JavaObject>> children;

    public JavaMap(Accessor parent, MapBinding binding, Object object, AccessorParams params) {
        super(parent, binding, object, params);
        this.children = new TreeMap(binding.getKeyBinding());
    }

    @Override
    public MapType type() {
        return (MapType)this.binding.type();
    }

    @Override
    public MapBinding getBinding() {
        return (MapBinding)this.binding;
    }

    public Binding getKeyBinding() {
        return this.getBinding().getKeyBinding();
    }

    public Binding getValueBinding() {
        return this.getBinding().getValueBinding();
    }

    @Override
    public void clear() throws AccessorException {
        this.writeLock();
        try {
            if (this.getBinding().size(this.object) == 0) {
                return;
            }
            try {
                boolean hasListeners = this.listeners != null;
                Binding kb = this.getKeyBinding();
                Object[] keys = hasListeners ? this.getBinding().getKeys(this.object) : null;
                this.getBinding().clear(this.object);
                for (SoftReference<JavaObject> ref : this.children.values()) {
                    JavaObject sa = ref.get();
                    if (sa == null) continue;
                    sa.invalidatedNotification();
                }
                this.children.clear();
                ListenerEntry le = this.listeners;
                while (le != null) {
                    MapInterestSet is = (MapInterestSet)le.getInterestSet();
                    Object[] objectArray = keys;
                    int n = keys.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object key = objectArray[n2];
                        MutableVariant var = new MutableVariant(kb, key);
                        if (is.inNotificationsOf(var)) {
                            MapEntryRemoved e = new MapEntryRemoved(var);
                            this.emitEvent(le, e);
                        }
                        ++n2;
                    }
                    le = le.next;
                }
            }
            catch (BindingException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    void removeLocal(Object lk) throws AccessorException {
        this.writeLock();
        try {
            boolean hadValue = this.getBinding().containsKey(this.object, lk);
            if (!hadValue) {
                return;
            }
            try {
                this.getBinding().remove(this.object, lk);
                JavaObject sa = this.getExistingAccessor(lk);
                if (sa != null) {
                    sa.invalidatedNotification();
                    this.children.remove(lk);
                }
                if (this.listeners != null) {
                    MutableVariant var = new MutableVariant(this.getKeyBinding(), lk);
                    ListenerEntry le = this.listeners;
                    while (le != null) {
                        MapInterestSet is = (MapInterestSet)le.getInterestSet();
                        if (is.inNotificationsOf(var)) {
                            MapEntryRemoved e = new MapEntryRemoved(var);
                            this.emitEvent(le, e);
                        }
                        le = le.next;
                    }
                }
            }
            catch (BindingException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    void putLocal(Object lk, Object lv) throws AccessorException {
        this.writeLock();
        try {
            try {
                JavaObject sa = this.getExistingAccessor(lk);
                if (sa == null) {
                    boolean hadOldValue = this.getBinding().containsKey(this.object, lk);
                    Binding kb = this.getKeyBinding();
                    Binding vb = this.getValueBinding();
                    if (hadOldValue) {
                        this.getBinding().get(this.object, lk);
                    }
                    this.getBinding().put(this.object, lk, lv);
                    MutableVariant kv = new MutableVariant(kb, lk);
                    if (this.listeners != null) {
                        ListenerEntry le = this.listeners;
                        while (le != null) {
                            MapInterestSet is = (MapInterestSet)le.getInterestSet();
                            if (is.inNotificationsOf(kv)) {
                                MutableVariant vv = null;
                                if (is.inValuesOf(kv)) {
                                    vv = new MutableVariant(vb, vb.isImmutable() ? lv : vb.clone(lv));
                                }
                                if (hadOldValue) {
                                    e = new ValueAssigned(new KeyReference(kv), vv);
                                    this.emitEvent(le, e);
                                } else {
                                    e = new MapEntryAdded(kv, vv);
                                    this.emitEvent(le, e);
                                }
                            }
                            le = le.next;
                        }
                    }
                } else {
                    sa.setValue(this.getValueBinding(), lv);
                }
            }
            catch (BindingException e) {
                throw new AccessorException(e);
            }
            catch (AdaptException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void put(Binding keyBinding, Object key, Binding valueBinding, Object value) throws AccessorException {
        this.writeLock();
        try {
            try {
                Object rk = key;
                Object rv = value;
                Adapter ka = this.params.adapterScheme.getAdapter(keyBinding, this.getKeyBinding(), true, false);
                Adapter va = this.params.adapterScheme.getAdapter(valueBinding, this.getValueBinding(), true, false);
                Object lk = ka.adapt(rk);
                Object lv = va.adapt(rv);
                this.putLocal(lk, lv);
            }
            catch (AdapterConstructionException e) {
                throw new AccessorException(e);
            }
            catch (AdaptException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void putAll(Binding keyBinding, Binding valueBinding, Map<Object, Object> from) throws AccessorException {
        this.writeLock();
        try {
            try {
                Adapter ka = this.params.adapterScheme.getAdapter(keyBinding, this.getKeyBinding(), true, false);
                Adapter va = this.params.adapterScheme.getAdapter(valueBinding, this.getValueBinding(), true, false);
                for (Object rk : from.keySet()) {
                    Object rv = from.get(rk);
                    Object lk = ka.adapt(rk);
                    Object lv = va.adapt(rv);
                    this.putLocal(lk, lv);
                }
            }
            catch (AdaptException e) {
                throw new AccessorException(e);
            }
            catch (AdapterConstructionException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void putAll(Binding keyBinding, Binding valueBinding, Object[] keys, Object[] values) throws AccessorException {
        this.writeLock();
        try {
            try {
                int rs = keys.length;
                Adapter ka = this.params.adapterScheme.getAdapter(keyBinding, this.getKeyBinding(), true, false);
                Adapter va = this.params.adapterScheme.getAdapter(valueBinding, this.getValueBinding(), true, false);
                int i = 0;
                while (i < rs) {
                    Object lk = ka.adapt(keys[i]);
                    Object lv = va.adapt(values[i]);
                    this.putLocal(lk, lv);
                    ++i;
                }
            }
            catch (AdaptException e) {
                throw new AccessorException(e);
            }
            catch (AdapterConstructionException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void remove(Binding keyBinding, Object key) throws AccessorException {
        try {
            Object rk = key;
            Object lk = this.adapt(rk, keyBinding, this.getKeyBinding());
            this.removeLocal(lk);
        }
        catch (AdaptException e) {
            throw new AccessorException(e);
        }
        catch (AdapterConstructionException e) {
            throw new AccessorException(e);
        }
    }

    @Override
    public void setValue(Binding mapBinding, Object newMap) throws AccessorException {
        try {
            MapBinding mb = (MapBinding)mapBinding;
            int newSize = mb.size(newMap);
            Object[] rks = new Object[newSize];
            Object[] rvs = new Object[newSize];
            mb.getAll(newMap, rks, rvs);
            Adapter ka = this.params.adapterScheme.getAdapter(mb.getKeyBinding(), this.getKeyBinding(), true, false);
            Adapter va = this.params.adapterScheme.getAdapter(mb.getValueBinding(), this.getValueBinding(), true, false);
            int i = 0;
            while (i < newSize) {
                rks[i] = ka.adapt(rks[i]);
                rvs[i] = va.adapt(rvs[i]);
                ++i;
            }
            this.setValueLocal(rks, rvs);
        }
        catch (BindingException e) {
            throw new AccessorException(e);
        }
        catch (AdapterConstructionException e) {
            throw new AccessorException(e);
        }
        catch (AdaptException e) {
            throw new AccessorException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    void setValueLocal(Object[] keys, Object[] values) throws AccessorException {
        this.writeLock();
        try {
            try {
                void var4_6;
                TreeSet<Object> oldKeys = new TreeSet<Object>(this.getKeyBinding());
                this.getBinding().getKeys(this.object, oldKeys);
                boolean bl = false;
                while (var4_6 < keys.length) {
                    Object key = keys[var4_6];
                    Object value = values[var4_6];
                    this.putLocal(key, value);
                    oldKeys.remove(key);
                    ++var4_6;
                }
                for (Object e : oldKeys) {
                    this.removeLocal(e);
                }
            }
            catch (BindingException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public <T extends Accessor> T getValueAccessor(Binding keyBinding, Object key) throws AccessorConstructionException {
        try {
            Object rk = key;
            Object lk = this.params.adapterScheme.getAdapter(keyBinding, this.getKeyBinding(), true, this.listeners != null).adapt(rk);
            boolean hasKey = this.getBinding().containsKey(this.object, lk);
            if (!hasKey) {
                throw new AccessorConstructionException("Map doesn't contain the requested element");
            }
            JavaObject sa = this.getExistingAccessor(lk);
            if (sa != null) {
                return (T)sa;
            }
            this.readLock();
            try {
                Binding vb = this.getBinding().getValueBinding();
                Binding kb = this.getBinding().getKeyBinding();
                Object lv = this.getBinding().get(this.object, lk);
                MutableVariant kv = new MutableVariant(kb, lk);
                sa = JavaMap.createSubAccessor(this, vb, lv, this.params);
                sa.keyInParent = lk;
                this.children.put(lk, new SoftReference<JavaObject>(sa));
                ListenerEntry le = this.listeners;
                while (le != null) {
                    InterestSet cis;
                    MapInterestSet is = (MapInterestSet)le.getInterestSet();
                    InterestSet gis = is.getComponentInterest();
                    if (gis != null) {
                        try {
                            ChildReference childPath = ChildReference.concatenate(le.path, new KeyReference(kv));
                            sa.addListener(le.listener, gis, childPath, le.executor);
                        }
                        catch (AccessorException e) {
                            throw new AccessorConstructionException(e);
                        }
                    }
                    if ((cis = is.getComponentInterest(kv)) != null) {
                        try {
                            ChildReference childPath = ChildReference.concatenate(le.path, new KeyReference(kv));
                            sa.addListener(le.listener, cis, childPath, le.executor);
                        }
                        catch (AccessorException e) {
                            throw new AccessorConstructionException(e);
                        }
                    }
                    le = le.next;
                }
            }
            finally {
                this.readUnlock();
            }
            return (T)sa;
        }
        catch (BindingException e) {
            throw new AccessorConstructionException(e);
        }
        catch (AdaptException e) {
            throw new AccessorConstructionException(e);
        }
        catch (AdapterConstructionException e) {
            throw new AccessorConstructionException(e);
        }
    }

    JavaObject getExistingAccessor(Object localKey) {
        SoftReference<JavaObject> ref = this.children.get(localKey);
        if (ref == null) {
            return null;
        }
        JavaObject result = ref.get();
        if (result == null) {
            this.children.remove(localKey);
            return null;
        }
        return result;
    }

    @Override
    public <T extends Accessor> T getComponent(ChildReference reference) throws AccessorConstructionException {
        if (reference == null) {
            return (T)this;
        }
        if (reference instanceof LabelReference) {
            LabelReference lr = (LabelReference)reference;
            try {
                Binding kb = this.getKeyBinding();
                MutableVariant variant = (MutableVariant)this.adapt(lr.label, Bindings.STRING, Bindings.MUTABLE_VARIANT);
                Object value = variant.getValue(kb);
                T result = this.getValueAccessor(kb, value);
                if (reference.getChildReference() != null) {
                    result = result.getComponent(reference.getChildReference());
                }
                return result;
            }
            catch (AdaptException e2) {
                throw new ReferenceException(e2);
            }
            catch (AdapterConstructionException e) {
                throw new ReferenceException(e);
            }
        }
        if (reference instanceof KeyReference) {
            KeyReference ref = (KeyReference)reference;
            T result = this.getValueAccessor(ref.key.getBinding(), ref.key.getValue());
            if (reference.getChildReference() != null) {
                result = result.getComponent(reference.getChildReference());
            }
            return result;
        }
        throw new ReferenceException(reference.getClass().getName() + " is not a reference of a map");
    }

    @Override
    public int size() throws AccessorException {
        this.readLock();
        try {
            int n = this.getBinding().size(this.object);
            return n;
        }
        catch (BindingException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public boolean containsKey(Binding keyBinding, Object key) throws AccessorException {
        this.readLock();
        try {
            MapBinding mb = this.getBinding();
            Binding lkb = this.getKeyBinding();
            Binding rkb = keyBinding;
            Object rk = key;
            Object lk = this.adapt(rk, rkb, lkb);
            boolean bl = mb.containsKey(this.object, lk);
            return bl;
        }
        catch (AdaptException e) {
            throw new AccessorException(e);
        }
        catch (BindingException e) {
            throw new AccessorException(e);
        }
        catch (AdapterConstructionException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public boolean containsValue(Binding valueBinding, Object value) throws AccessorException {
        this.readLock();
        try {
            MapBinding mb = this.getBinding();
            Binding lvb = this.getValueBinding();
            Binding rvb = valueBinding;
            Object rv = value;
            Object lv = this.adapt(rv, rvb, lvb);
            boolean bl = mb.containsValue(this.object, lv);
            return bl;
        }
        catch (AdaptException e) {
            throw new AccessorException(e);
        }
        catch (BindingException e) {
            throw new AccessorException(e);
        }
        catch (AdapterConstructionException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public Object get(Binding keyBinding, Object key, Binding valueBinding) throws AccessorException {
        this.readLock();
        try {
            Object rv;
            MapBinding mb = this.getBinding();
            Binding lkb = this.getKeyBinding();
            Binding rkb = keyBinding;
            Binding lvb = this.getValueBinding();
            Binding rvb = valueBinding;
            Object rk = key;
            Object lk = this.adapt(rk, rkb, lkb);
            Object lv = mb.get(this.object, lk);
            if (lv == null) {
                return null;
            }
            Object object = rv = this.adapt(lv, lvb, rvb);
            return object;
        }
        catch (AdaptException e) {
            throw new AccessorException(e);
        }
        catch (BindingException e) {
            throw new AccessorException(e);
        }
        catch (AdapterConstructionException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public int count(Binding keyBinding, Object from, boolean fromInclusive, Object end, boolean endInclusive) throws AccessorException {
        this.readLock();
        try {
            MapBinding mb = this.getBinding();
            Object lf = this.params.adapterScheme.adapt(from, keyBinding, this.getKeyBinding());
            Object le = this.params.adapterScheme.adapt(end, keyBinding, this.getKeyBinding());
            int n = mb.count(this.object, lf, fromInclusive, le, endInclusive);
            return n;
        }
        catch (BindingException e) {
            throw new AccessorException(e);
        }
        catch (AdaptException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public int getEntries(Binding keyBinding, Object from, boolean fromInclusive, Object end, boolean endInclusive, ArrayBinding keyArrayBinding, Object keysArray, ArrayBinding valueArrayBinding, Object valueArray, int limit) throws AccessorException {
        this.readLock();
        try {
            MapBinding mb = this.getBinding();
            Object lfrom = this.params.adapterScheme.adapt(from, keyBinding, this.getKeyBinding());
            Object lend = this.params.adapterScheme.adapt(end, keyBinding, this.getKeyBinding());
            int n = mb.getEntries(this.object, lfrom, fromInclusive, lend, endInclusive, keyArrayBinding, keysArray, valueArrayBinding, valueArray, limit);
            return n;
        }
        catch (BindingException e) {
            throw new AccessorException(e);
        }
        catch (AdaptException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public void getAll(Binding keyBinding, Binding valueBinding, Map<Object, Object> to) throws AccessorException {
        this.readLock();
        try {
            try {
                MapBinding mb = this.getBinding();
                Adapter ka = this.params.adapterScheme.getAdapter(this.getKeyBinding(), keyBinding, true, false);
                Adapter va = this.params.adapterScheme.getAdapter(this.getValueBinding(), valueBinding, true, false);
                int length = mb.size(this.object);
                Object[] keys = new Object[length];
                Object[] values = new Object[length];
                mb.getAll(this.object, keys, values);
                int i = 0;
                while (i < length) {
                    Object lk = keys[i];
                    Object lv = values[i];
                    Object rk = ka.adapt(lk);
                    Object rv = va.adapt(lv);
                    to.put(rk, rv);
                    ++i;
                }
            }
            catch (AdaptException e) {
                throw new AccessorException(e);
            }
            catch (AdapterConstructionException e) {
                throw new AccessorException(e);
            }
            catch (BindingException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public void getAll(Binding keyBinding, Binding valueBinding, Object[] keys, Object[] values) throws AccessorException {
        this.readLock();
        try {
            try {
                int length = this.getBinding().size(this.object);
                this.getBinding().getAll(this.object, keys, values);
                Adapter ka = this.params.adapterScheme.getAdapter(this.getKeyBinding(), keyBinding, true, false);
                Adapter va = this.params.adapterScheme.getAdapter(this.getValueBinding(), valueBinding, true, false);
                int i = 0;
                while (i < length) {
                    keys[i] = ka.adapt(keys[i]);
                    values[i] = va.adapt(values[i]);
                    ++i;
                }
            }
            catch (AdaptException e) {
                throw new AccessorException(e);
            }
            catch (AdapterConstructionException e) {
                throw new AccessorException(e);
            }
            catch (BindingException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public Object[] getKeys(Binding keyBinding) throws AccessorException {
        this.readLock();
        try {
            Object[] result = this.getBinding().getKeys(this.object);
            Adapter adapter = this.params.adapterScheme.getAdapter(this.getKeyBinding(), keyBinding, true, false);
            int i = 0;
            while (i < result.length) {
                result[i] = adapter.adapt(result[i]);
                ++i;
            }
            Object[] objectArray = result;
            return objectArray;
        }
        catch (AdaptException e) {
            throw new AccessorException(e);
        }
        catch (AdapterConstructionException e) {
            throw new AccessorException(e);
        }
        catch (BindingException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public Object[] getValues(Binding valueBinding) throws AccessorException {
        this.readLock();
        try {
            Object[] result = this.getBinding().getValues(this.object);
            Adapter adapter = this.params.adapterScheme.getAdapter(this.getValueBinding(), valueBinding, true, false);
            int i = 0;
            while (i < result.length) {
                result[i] = adapter.adapt(result[i]);
                ++i;
            }
            Object[] objectArray = result;
            return objectArray;
        }
        catch (AdaptException e) {
            throw new AccessorException(e);
        }
        catch (AdapterConstructionException e) {
            throw new AccessorException(e);
        }
        catch (BindingException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public Object getCeilingKey(Binding keyBinding, Object key) throws AccessorException {
        this.readLock();
        try {
            Object rck;
            Binding lkb = this.getKeyBinding();
            Binding rkb = keyBinding;
            Object rk = key;
            Object lk = this.adapt(rk, rkb, lkb);
            Object lck = this.getBinding().getCeilingKey(this.object, lk);
            if (lck == null) {
                return null;
            }
            Object object = rck = this.adapt(lck, lkb, rkb);
            return object;
        }
        catch (AdaptException e) {
            throw new AccessorException(e);
        }
        catch (AdapterConstructionException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public Object getFirstKey(Binding keyBinding) throws AccessorException {
        this.readLock();
        try {
            Object rfk;
            Binding lkb = this.getKeyBinding();
            Binding rkb = keyBinding;
            Object lfk = this.getBinding().getFirstKey(this.object);
            Object object = rfk = this.adapt(lfk, lkb, rkb);
            return object;
        }
        catch (AdaptException e) {
            throw new AccessorException(e);
        }
        catch (AdapterConstructionException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public Object getLastKey(Binding keyBinding) throws AccessorException {
        this.readLock();
        try {
            Object rfk;
            Binding lkb = this.getKeyBinding();
            Binding rkb = keyBinding;
            Object lfk = this.getBinding().getLastKey(this.object);
            Object object = rfk = this.adapt(lfk, lkb, rkb);
            return object;
        }
        catch (AdaptException e) {
            throw new AccessorException(e);
        }
        catch (AdapterConstructionException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public Object getFloorKey(Binding keyBinding, Object key) throws AccessorException {
        this.readLock();
        try {
            Object rfk;
            Binding lkb = this.getKeyBinding();
            Binding rkb = keyBinding;
            Object rk = key;
            Object lk = this.adapt(rk, rkb, lkb);
            Object lfk = this.getBinding().getFloorKey(this.object, lk);
            if (lfk == null) {
                return null;
            }
            Object object = rfk = this.adapt(lfk, lkb, rkb);
            return object;
        }
        catch (AdaptException e) {
            throw new AccessorException(e);
        }
        catch (AdapterConstructionException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public Object getHigherKey(Binding keyBinding, Object key) throws AccessorException {
        this.readLock();
        try {
            Object rhk;
            Binding lkb = this.getKeyBinding();
            Binding rkb = keyBinding;
            Object rk = key;
            Object lk = this.adapt(rk, rkb, lkb);
            Object lhk = this.getBinding().getHigherKey(this.object, lk);
            if (lhk == null) {
                return null;
            }
            Object object = rhk = this.adapt(lhk, lkb, rkb);
            return object;
        }
        catch (AdaptException e) {
            throw new AccessorException(e);
        }
        catch (AdapterConstructionException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public Object getLowerKey(Binding keyBinding, Object key) throws AccessorException {
        this.readLock();
        try {
            Object rlk;
            Binding lkb = this.getKeyBinding();
            Binding rkb = keyBinding;
            Object rk = key;
            Object lk = this.adapt(rk, rkb, lkb);
            Object llk = this.getBinding().getLowerKey(this.object, lk);
            if (llk == null) {
                return null;
            }
            Object object = rlk = this.adapt(llk, lkb, rkb);
            return object;
        }
        catch (AdaptException e) {
            throw new AccessorException(e);
        }
        catch (AdapterConstructionException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public void addListener(Accessor.Listener listener, InterestSet interestSet, ChildReference path, Executor executor) throws AccessorException {
        super.addListener(listener, interestSet, path, executor);
        MapInterestSet is = (MapInterestSet)interestSet;
        Binding kb = this.getBinding().getKeyBinding();
        for (Object key : this.children.keySet()) {
            ChildReference childPath;
            JavaObject sa = this.getExistingAccessor(key);
            if (sa == null) continue;
            MutableVariant vkey = new MutableVariant(kb, key);
            InterestSet cis = is.getComponentInterest();
            if (cis != null) {
                childPath = ChildReference.concatenate(path, new KeyReference(vkey));
                sa.addListener(listener, cis, childPath, executor);
            }
            if ((cis = is.getComponentInterest(vkey)) == null) continue;
            childPath = ChildReference.concatenate(path, new KeyReference(vkey));
            sa.addListener(listener, cis, childPath, executor);
        }
    }

    @Override
    public void removeListener(Accessor.Listener listener) throws AccessorException {
        ListenerEntry e = this.detachListener(listener);
        if (e == null) {
            return;
        }
        MapInterestSet is = (MapInterestSet)e.interestSet;
        Binding kb = this.getBinding().getKeyBinding();
        for (Map.Entry<Object, SoftReference<JavaObject>> entry : this.children.entrySet()) {
            JavaObject sa = entry.getValue().get();
            if (sa == null) continue;
            Object key = entry.getKey();
            MutableVariant vkey = new MutableVariant(kb, key);
            InterestSet cis = is.getComponentInterest();
            if (cis != null) {
                sa.removeListener(listener);
            }
            if ((cis = is.getComponentInterest(vkey)) == null) continue;
            sa.removeListener(listener);
        }
    }

    @Override
    Event applyLocal(Event e, boolean makeRollback) throws AccessorException {
        ModificationEvent rollback = null;
        if (e instanceof ValueAssigned) {
            ValueAssigned va = (ValueAssigned)e;
            if (makeRollback) {
                rollback = new ValueAssigned(this.getBinding(), this.getValue(this.getBinding()));
            }
            this.setValue(va.newValue.getBinding(), va.newValue.getValue());
            return rollback;
        }
        if (e instanceof MapEntryAdded) {
            MapEntryAdded ea = (MapEntryAdded)e;
            if (ea.key == null) {
                throw new AccessorException("Cannot apply entry added event because key is missing");
            }
            if (ea.value == null) {
                throw new AccessorException("Cannot apply entry added event because value is missing");
            }
            boolean hadValue = this.containsKey(ea.key.getBinding(), ea.key.getValue());
            if (hadValue) {
                throw new AccessorException("Could not add entry to key that already existed");
            }
            if (makeRollback) {
                rollback = new MapEntryRemoved(ea.key);
            }
            this.put(ea.key.getBinding(), ea.key.getValue(), ea.value.getBinding(), ea.value.getValue());
        } else if (e instanceof MapEntryRemoved) {
            MapEntryRemoved er = (MapEntryRemoved)e;
            if (makeRollback) {
                boolean hadValue = this.containsKey(er.key.getBinding(), er.key.getValue());
                if (hadValue) {
                    Object oldValueObj = this.get(er.key.getBinding(), er.key.getValue(), this.getBinding().getValueBinding());
                    MutableVariant oldKey = er.key;
                    MutableVariant oldValue = new MutableVariant(this.getBinding().getValueBinding(), oldValueObj);
                    rollback = new MapEntryAdded(oldKey, oldValue);
                } else {
                    rollback = new MapEntryRemoved(er.key.clone());
                }
            }
            this.remove(er.key.getBinding(), er.key.getValue());
        } else {
            throw new AccessorException("Cannot apply " + e.getClass().getName() + " to Map Type");
        }
        return rollback;
    }
}

