/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.accessor.interestset;

import java.util.Map;
import java.util.TreeMap;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.interestset.InterestSet;
import org.simantics.databoard.annotations.Optional;
import org.simantics.databoard.binding.mutable.Variant;

public class MapInterestSet
extends InterestSet {
    public boolean notification;
    @Optional
    public Variant[] notifications;
    public boolean value;
    @Optional
    public Variant[] values;
    @Optional
    public InterestSet componentInterest;
    @Optional
    public Map<Variant, InterestSet> componentInterests;

    public MapInterestSet() {
    }

    public MapInterestSet(boolean notification, Variant[] notifications, boolean value, Variant[] values, InterestSet componentInterest, Map<Variant, InterestSet> componentInterests) {
        this.notification = notification;
        this.notifications = notifications;
        this.value = value;
        this.values = values;
        this.componentInterest = componentInterest;
        this.componentInterests = componentInterests;
    }

    @Override
    public boolean inNotifications() {
        return this.notification | this.value | this.componentInterest != null;
    }

    public boolean inNotificationsOf(Variant key) {
        int i;
        if (this.notification || this.value) {
            return true;
        }
        if (this.notifications != null) {
            i = 0;
            while (i < this.notifications.length) {
                if (this.notifications[i] == key) {
                    return true;
                }
                ++i;
            }
        }
        if (this.values != null) {
            i = 0;
            while (i < this.values.length) {
                if (this.values[i] == key) {
                    return true;
                }
                ++i;
            }
        }
        if (this.componentInterests != null) {
            InterestSet compositeInterest = this.componentInterests.get(key);
            return compositeInterest != null;
        }
        return false;
    }

    @Override
    public boolean inValues() {
        return this.value | this.componentInterest != null;
    }

    public boolean inValuesOf(Variant key) {
        if (this.value | this.componentInterest != null) {
            return true;
        }
        if (this.values != null) {
            int i = 0;
            while (i < this.values.length) {
                if (this.values[i] == key) {
                    return true;
                }
                ++i;
            }
        }
        return this.componentInterests != null && this.componentInterests.containsKey(key);
    }

    public InterestSet getComponentInterest() {
        return this.componentInterest;
    }

    public InterestSet getComponentInterest(Variant key) {
        if (this.componentInterests == null) {
            return null;
        }
        return this.componentInterests.get(key);
    }

    public void addCompositeInterest(Variant key, InterestSet cis) {
        if (this.componentInterests == null) {
            this.componentInterests = new TreeMap<Object, InterestSet>(Bindings.VARIANT);
        }
        this.componentInterests.put(key, cis);
    }
}

