/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.accessor.impl;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.MapAccessor;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.BooleanBinding;
import org.simantics.databoard.binding.NumberBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.impl.BooleanArrayBinding;
import org.simantics.databoard.binding.impl.ByteArrayBinding;
import org.simantics.databoard.binding.impl.DoubleArrayBinding;
import org.simantics.databoard.binding.impl.FloatArrayBinding;
import org.simantics.databoard.binding.impl.IntArrayBinding;
import org.simantics.databoard.binding.impl.LongArrayBinding;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.util.Limit;
import org.simantics.databoard.util.Range;

public class MapAccessorIterator<K, V> {
    MapAccessor map;
    Binding keyBinding;
    Binding valueBinding;
    Object from;
    boolean fromInclusive;
    Object end;
    boolean endInclusive;
    ArrayBinding keyCacheBinding;
    Object keyCache;
    ArrayBinding valueCacheBinding;
    Object valueCache;
    int index = -1;
    int samplesInCache = 0;
    int cacheIndex = -1;

    public MapAccessorIterator(MapAccessor map, Binding keyBinding, Object from, boolean fromInclusive, Object end, boolean endInclusive, ArrayBinding keyCacheBinding, Object keyCache, ArrayBinding valueCacheBinding, Object valueCache) {
        this.map = map;
        this.keyBinding = keyBinding;
        this.from = from;
        this.fromInclusive = fromInclusive;
        this.end = end;
        this.endInclusive = endInclusive;
        this.valueBinding = valueCacheBinding.getComponentBinding();
        this.keyCacheBinding = keyCacheBinding;
        this.keyCache = keyCache;
        this.valueCacheBinding = valueCacheBinding;
        this.valueCache = valueCache;
    }

    public MapAccessorIterator(MapAccessor map, Binding keyBinding, Object from, boolean fromInclusive, Object end, boolean endInclusive, Binding valueBinding, int cacheSize) throws BindingException, AccessorException {
        this.map = map;
        this.keyBinding = keyBinding;
        this.from = from;
        this.fromInclusive = fromInclusive;
        this.end = end;
        this.endInclusive = endInclusive;
        this.valueBinding = valueBinding;
        Range range = new Range(Limit.inclusive(cacheSize), Limit.nolimit());
        this.keyCacheBinding = (ArrayBinding)Bindings.getBinding(new ArrayType(keyBinding.type(), range));
        this.keyCache = this.keyCacheBinding.createDefault();
        this.valueCacheBinding = (ArrayBinding)Bindings.getBinding(new ArrayType(valueBinding.type(), range));
        this.valueCache = this.valueCacheBinding.createDefault();
    }

    private void fillCache() throws AccessorException {
        try {
            int limit = Math.min(this.keyCacheBinding.size(this.keyCache), this.valueCacheBinding.size(this.valueCache));
            if (limit == 0) {
                throw new AccessorException("You should have some entries in the cache");
            }
            this.cacheIndex = -1;
            if (this.from == null) {
                this.samplesInCache = 0;
                return;
            }
            this.samplesInCache = this.map.getEntries(this.keyBinding, this.from, this.fromInclusive, this.end, this.endInclusive, this.keyCacheBinding, this.keyCache, this.valueCacheBinding, this.valueCache, limit);
            if (this.samplesInCache == 0) {
                this.from = null;
                return;
            }
            this.from = this.keyCacheBinding.get(this.keyCache, this.samplesInCache - 1);
            this.fromInclusive = false;
        }
        catch (BindingException e) {
            throw new AccessorException(e);
        }
    }

    public boolean hasNext() throws AccessorException {
        if (this.from == null) {
            return false;
        }
        if (this.cacheIndex >= this.samplesInCache - 1) {
            this.fillCache();
        }
        if (this.cacheIndex >= this.samplesInCache - 1) {
            return false;
        }
        return this.cacheIndex + 1 < this.samplesInCache;
    }

    public boolean next() throws AccessorException {
        if (this.from == null) {
            return false;
        }
        if (this.cacheIndex >= this.samplesInCache - 1) {
            this.fillCache();
        }
        if (this.cacheIndex >= this.samplesInCache - 1) {
            return false;
        }
        ++this.cacheIndex;
        ++this.index;
        return true;
    }

    public K key() throws AccessorException {
        try {
            return (K)this.keyCacheBinding.get(this.keyCache, this.cacheIndex);
        }
        catch (IndexOutOfBoundsException e) {
            throw new AccessorException(e);
        }
        catch (BindingException e) {
            throw new AccessorException(e);
        }
    }

    public V value() throws AccessorException {
        try {
            return (V)this.valueCacheBinding.get(this.valueCache, this.cacheIndex);
        }
        catch (IndexOutOfBoundsException e) {
            throw new AccessorException(e);
        }
        catch (BindingException e) {
            throw new AccessorException(e);
        }
    }

    public double keyDouble() throws AccessorException {
        try {
            if (this.keyCacheBinding instanceof FloatArrayBinding) {
                return ((float[])this.keyCache)[this.cacheIndex];
            }
            if (this.keyCacheBinding instanceof DoubleArrayBinding) {
                return ((double[])this.keyCache)[this.cacheIndex];
            }
            if (this.keyCacheBinding instanceof ByteArrayBinding) {
                return ((byte[])this.keyCache)[this.cacheIndex];
            }
            if (this.keyCacheBinding instanceof IntArrayBinding) {
                return ((int[])this.keyCache)[this.cacheIndex];
            }
            if (this.keyCacheBinding instanceof LongArrayBinding) {
                return ((long[])this.keyCache)[this.cacheIndex];
            }
            if (this.keyCacheBinding instanceof BooleanArrayBinding) {
                return ((boolean[])this.keyCache)[this.cacheIndex] ? 1.0 : 0.0;
            }
            Object o = this.keyCacheBinding.get(this.keyCache, this.cacheIndex);
            Binding b = this.keyCacheBinding.getComponentBinding();
            if (b instanceof BooleanBinding) {
                return ((BooleanBinding)b).getValue(o) != false ? 1.0 : 0.0;
            }
            NumberBinding nb = (NumberBinding)b;
            return nb.getValue(o).doubleValue();
        }
        catch (IndexOutOfBoundsException e) {
            throw new AccessorException(e);
        }
        catch (BindingException e) {
            throw new AccessorException(e);
        }
    }

    public double valueDouble() throws AccessorException {
        try {
            if (this.valueCacheBinding instanceof FloatArrayBinding) {
                return ((float[])this.valueCache)[this.cacheIndex];
            }
            if (this.valueCacheBinding instanceof DoubleArrayBinding) {
                return ((double[])this.valueCache)[this.cacheIndex];
            }
            if (this.valueCacheBinding instanceof ByteArrayBinding) {
                return ((byte[])this.valueCache)[this.cacheIndex];
            }
            if (this.valueCacheBinding instanceof IntArrayBinding) {
                return ((int[])this.valueCache)[this.cacheIndex];
            }
            if (this.valueCacheBinding instanceof LongArrayBinding) {
                return ((long[])this.valueCache)[this.cacheIndex];
            }
            if (this.valueCacheBinding instanceof BooleanArrayBinding) {
                return ((boolean[])this.valueCache)[this.cacheIndex] ? 1.0 : 0.0;
            }
            Object o = this.valueCacheBinding.get(this.valueCache, this.cacheIndex);
            Binding b = this.valueCacheBinding.getComponentBinding();
            if (b instanceof BooleanBinding) {
                return ((BooleanBinding)b).getValue(o) != false ? 1.0 : 0.0;
            }
            NumberBinding nb = (NumberBinding)b;
            return nb.getValue(o).doubleValue();
        }
        catch (IndexOutOfBoundsException e) {
            throw new AccessorException(e);
        }
        catch (BindingException e) {
            throw new AccessorException(e);
        }
    }

    public int index() {
        return this.index;
    }
}

