/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.accessor.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Executor;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.accessor.event.Event;
import org.simantics.databoard.accessor.interestset.InterestSet;
import org.simantics.databoard.accessor.reference.ChildReference;

public class ListenerEntry {
    public Accessor.Listener listener;
    public InterestSet interestSet;
    public ChildReference path;
    public Executor executor;
    public ListenerEntry next;

    public ListenerEntry(Accessor.Listener listener, InterestSet interestSet, ChildReference path, Executor executor) {
        if (interestSet == null) {
            throw new IllegalArgumentException();
        }
        this.listener = listener;
        this.interestSet = interestSet;
        this.path = path;
        this.executor = executor;
    }

    public static ListenerEntry link(ListenerEntry prevValue, Accessor.Listener listener, InterestSet interestSet, ChildReference path, Executor executor) {
        ListenerEntry e = new ListenerEntry(listener, interestSet, path, executor);
        e.next = prevValue;
        return e;
    }

    public <T extends InterestSet> T getInterestSet() {
        return (T)this.interestSet;
    }

    public static ListenerEntry remove(ListenerEntry firstEntry, Accessor.Listener listener) {
        ListenerEntry e = firstEntry;
        ListenerEntry p = null;
        while (e != null) {
            if (e.listener == listener) {
                if (p == null) {
                    return e.next;
                }
                p.next = e.next;
                return firstEntry;
            }
            p = e;
            e = e.next;
        }
        return null;
    }

    public void emitEvent(final Event e) {
        if (this.executor == null) {
            this.listener.onEvents(Collections.singleton(e));
        } else {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ListenerEntry.this.listener.onEvents(Collections.singleton(e));
                }
            });
        }
    }

    public void emitEvents(final Collection<Event> events) {
        if (this.executor == null) {
            this.listener.onEvents(events);
        } else {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ListenerEntry.this.listener.onEvents(events);
                }
            });
        }
    }
}

