/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.accessor.file;

import java.io.File;
import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.accessor.binary.BinaryObject;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.file.FileVariantAccessor;
import org.simantics.databoard.accessor.impl.AccessorParams;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.util.binary.BinaryFile;

public class FileLibrary {
    Map<File, Entry> files = new HashMap<File, Entry>();
    ReferenceQueue<FileVariantAccessor> queue = new ReferenceQueue();
    AccessorParams params;

    public FileLibrary() {
        this.params = AccessorParams.DEFAULT;
    }

    public FileLibrary(AccessorParams params) {
        this.params = params;
    }

    public FileVariantAccessor getExistingFile(File file) throws AccessorConstructionException {
        FileVariantAccessor accessor;
        Entry ref = this.files.get(file = file.getAbsoluteFile());
        FileVariantAccessor fileVariantAccessor = accessor = ref == null ? null : (FileVariantAccessor)ref.get();
        if (ref != null && !ref.file.isOpen()) {
            this.files.remove(file);
            return null;
        }
        this.expunge();
        return accessor;
    }

    public FileVariantAccessor getFile(File file) throws AccessorConstructionException {
        Entry ref = this.files.get(file = file.getAbsoluteFile());
        FileVariantAccessor accessor = ref == null ? null : (FileVariantAccessor)ref.get();
        this.expunge();
        if (ref != null && !ref.file.isOpen()) {
            this.files.remove(file);
            ref = null;
        }
        if (accessor == null) {
            BinaryFile bf;
            BinaryFile binaryFile = bf = ref != null ? ref.file : null;
            if (bf == null) {
                try {
                    bf = new BinaryFile(file);
                }
                catch (IOException e1) {
                    throw new AccessorConstructionException(e1);
                }
            }
            accessor = (FileVariantAccessor)((Object)BinaryObject.createAccessor(bf, Datatypes.VARIANT, this.params));
            Entry e = new Entry(bf, accessor);
            this.files.put(file, e);
        }
        return accessor;
    }

    public FileVariantAccessor createFile(File file) throws AccessorConstructionException {
        Entry ref = this.files.get(file = file.getAbsoluteFile());
        FileVariantAccessor accessor = ref == null ? null : (FileVariantAccessor)ref.get();
        this.expunge();
        if (ref != null && !ref.file.isOpen()) {
            this.files.remove(file);
            ref = null;
        }
        if (accessor == null) {
            BinaryFile bf;
            BinaryFile binaryFile = bf = ref != null ? ref.file : null;
            if (bf == null) {
                try {
                    file.createNewFile();
                    bf = new BinaryFile(file);
                }
                catch (IOException e1) {
                    throw new AccessorConstructionException(e1);
                }
            }
            accessor = (FileVariantAccessor)((Object)BinaryObject.createAccessor(bf, Datatypes.VARIANT, this.params));
            try {
                Object vb = Bindings.getBinding(Void.TYPE);
                Object vv = ((Binding)vb).createDefault();
                accessor.setContentValue((Binding)vb, vv);
            }
            catch (BindingConstructionException e1) {
                throw new AccessorConstructionException(e1);
            }
            catch (AccessorException e) {
                throw new AccessorConstructionException(e);
            }
            catch (BindingException e) {
                throw new AccessorConstructionException(e);
            }
            Entry e = new Entry(bf, accessor);
            this.files.put(file, e);
        }
        return accessor;
    }

    public boolean deleteFile(File file) throws AccessorException {
        file = file.getAbsoluteFile();
        this.expunge();
        Entry ref = this.files.remove(file);
        if (ref != null) {
            FileVariantAccessor accessor = (FileVariantAccessor)ref.get();
            if (accessor != null) {
                accessor.close();
                accessor = null;
            } else {
                try {
                    ref.file.close();
                }
                catch (IOException e) {
                    throw new AccessorException(e);
                }
            }
        }
        this.expunge();
        if (!file.exists()) {
            return true;
        }
        boolean ok = file.delete();
        return ok;
    }

    public void expunge() {
        Entry e;
        while ((e = (Entry)this.queue.poll()) != null) {
            this.files.remove(e.file.file());
            try {
                e.file.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void close() {
        for (Entry e : this.files.values()) {
            try {
                e.file.flush();
                e.file.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        this.files.clear();
    }

    class Entry
    extends WeakReference<FileVariantAccessor> {
        BinaryFile file;

        public Entry(BinaryFile file, FileVariantAccessor accessor) {
            super(accessor, FileLibrary.this.queue);
            this.file = file;
        }
    }
}

