/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.accessor.binary;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.accessor.UnionAccessor;
import org.simantics.databoard.accessor.binary.BinaryObject;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.error.ReferenceException;
import org.simantics.databoard.accessor.event.Event;
import org.simantics.databoard.accessor.event.UnionValueAssigned;
import org.simantics.databoard.accessor.event.ValueAssigned;
import org.simantics.databoard.accessor.file.FileUnionAccessor;
import org.simantics.databoard.accessor.impl.AccessorParams;
import org.simantics.databoard.accessor.impl.ListenerEntry;
import org.simantics.databoard.accessor.interestset.InterestSet;
import org.simantics.databoard.accessor.interestset.UnionInterestSet;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.ComponentReference;
import org.simantics.databoard.accessor.reference.IndexReference;
import org.simantics.databoard.accessor.reference.LabelReference;
import org.simantics.databoard.accessor.reference.NameReference;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.UnionBinding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.MutableVariant;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.serialization.SerializerConstructionException;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.UnionType;
import org.simantics.databoard.util.binary.Blob;
import org.simantics.databoard.util.binary.Endian;

public class BinaryUnion
extends BinaryObject
implements UnionAccessor,
FileUnionAccessor {
    SoftReference<BinaryObject> component;

    public BinaryUnion(BinaryObject parent, Blob blob, Datatype type, AccessorParams params) {
        super(parent, blob, type, params);
    }

    @Override
    public UnionType type() {
        return (UnionType)this.type;
    }

    @Override
    public int count() {
        return this.type().getComponentCount();
    }

    @Override
    public void setValueNoflush(Binding binding, Object newValue) throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            try {
                UnionBinding ub = (UnionBinding)binding;
                int tag = ub.getTag(newValue);
                Binding cb = ub.getComponentBinding(tag);
                Object cv = ub.getValue(newValue);
                this.setComponentValueNoflush(tag, cb, cv);
            }
            catch (BindingException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public <T extends Accessor> T getComponentAccessor() throws AccessorConstructionException {
        assert (this.b.isOpen());
        this.readLock();
        try {
            BinaryObject sa = this.getExistingAccessor();
            if (sa == null) {
                this.b.position(0L);
                int tag = Endian.getUInt(this.b, this.count() - 1);
                int tagLen = (int)this.b.position();
                Datatype ct = this.type().getComponent((int)tag).type;
                sa = this.createSubAccessor(ct, tagLen, this.b.length() - (long)tagLen, this.params);
                this.component = new SoftReference<BinaryObject>(sa);
                ListenerEntry le = this.listeners;
                while (le != null) {
                    UnionInterestSet is = (UnionInterestSet)le.getInterestSet();
                    InterestSet cis = is.getComponentInterest(tag);
                    if (cis != null) {
                        try {
                            ChildReference childPath = ChildReference.concatenate(le.path, new ComponentReference());
                            sa.addListener(le.listener, cis, childPath, le.executor);
                        }
                        catch (AccessorException e) {
                            throw new AccessorConstructionException(e);
                        }
                    }
                    le = le.next;
                }
            }
            BinaryObject binaryObject = sa;
            return (T)binaryObject;
        }
        catch (IOException e) {
            throw new AccessorConstructionException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    BinaryObject getExistingAccessor() {
        SoftReference<BinaryObject> c = this.component;
        if (c == null) {
            return null;
        }
        return c.get();
    }

    @Override
    public Object getComponentValue(Binding componentBinding) throws AccessorException {
        assert (this.b.isOpen());
        this.readLock();
        try {
            this.b.position(0L);
            int tag = Endian.getUInt(this.b, this.count() - 1);
            Datatype ct = this.type().getComponent((int)tag).type;
            if (!ct.equals(componentBinding.type())) {
                throw new AccessorException("Binding of " + String.valueOf(ct) + " expected.");
            }
            ArrayList<Object> ids = new ArrayList<Object>(0);
            Serializer s = this.params.serializerScheme.getSerializer(componentBinding);
            Object object = s.deserialize(this.b, ids);
            return object;
        }
        catch (IOException e) {
            throw new AccessorException(e);
        }
        catch (SerializerConstructionException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public int getTag() throws AccessorException {
        assert (this.b.isOpen());
        this.readLock();
        try {
            this.b.position(0L);
            int n = Endian.getUInt(this.b, this.count() - 1);
            return n;
        }
        catch (IOException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public void setComponentValue(int tag, Binding componentBinding, Object componentValue) throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            this.setComponentValueNoflush(tag, componentBinding, componentValue);
            this.flush();
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public <T extends Accessor> T getComponent(ChildReference reference) throws AccessorConstructionException {
        assert (this.b.isOpen());
        this.readLock();
        try {
            if (reference == null) {
                BinaryUnion binaryUnion = this;
                return (T)binaryUnion;
            }
            if (reference instanceof LabelReference) {
                LabelReference lr = (LabelReference)reference;
                Integer tag = this.type().getComponentIndex(lr.label);
                if (tag == null && lr.label.equals("uv")) {
                    T result = this.getComponentAccessor();
                    if (reference.getChildReference() != null) {
                        result = result.getComponent(reference.getChildReference());
                    }
                    T t = result;
                    return t;
                }
                if (tag == null) {
                    throw new ReferenceException("Tag \"" + lr.label + "\" not found");
                }
                if (tag.intValue() != this.getTag()) {
                    throw new ReferenceException("The union isn't currently assigned with the expected type (" + this.type().getComponent((int)tag.intValue()).name + ")");
                }
                T result = this.getComponentAccessor();
                if (reference.getChildReference() != null) {
                    result = result.getComponent(reference.getChildReference());
                }
                T t = result;
                return t;
            }
            if (reference instanceof ComponentReference) {
                T result = this.getComponentAccessor();
                if (reference.getChildReference() != null) {
                    result = result.getComponent(reference.getChildReference());
                }
                T t = result;
                return t;
            }
            if (reference instanceof IndexReference) {
                IndexReference ir = (IndexReference)reference;
                if (ir.index < 0 || ir.index >= this.type().getComponentCount()) {
                    throw new ReferenceException("Tag index out of bounds");
                }
                if (ir.index != this.getTag()) {
                    throw new ReferenceException("The union isn't currently assigned with the expected type (" + this.type().getComponent((int)ir.index).name + ")");
                }
                T result = this.getComponentAccessor();
                if (reference.getChildReference() != null) {
                    result = result.getComponent(reference.getChildReference());
                }
                T t = result;
                return t;
            }
            if (reference instanceof NameReference) {
                NameReference nr = (NameReference)reference;
                Integer tag = this.type().getComponentIndex(nr.name);
                if (tag == null) {
                    throw new ReferenceException("Tag \"" + nr.name + "\" not found");
                }
                if (tag.intValue() != this.getTag()) {
                    throw new ReferenceException("The union isn't currently assigned with the expected type (" + this.type().getComponent((int)tag.intValue()).name + ")");
                }
                T result = this.getComponentAccessor();
                if (reference.getChildReference() != null) {
                    result = result.getComponent(reference.getChildReference());
                }
                T t = result;
                return t;
            }
            try {
                throw new ReferenceException(String.valueOf(reference.getClass()) + " is not a reference of OptionalType");
            }
            catch (AccessorException ae) {
                throw new AccessorConstructionException(ae);
            }
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public void setComponentValueNoflush(int tag, Binding cb, Object cv) throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            int oldTag = this.getTag();
            int newTag = tag;
            boolean hadSameTag = oldTag == newTag;
            BinaryObject sa = this.getExistingAccessor();
            if (sa != null && !hadSameTag) {
                this.component = null;
                sa.invalidatedNotification();
            }
            if (sa != null && hadSameTag) {
                sa.setValue(cb, cv);
                return;
            }
            try {
                UnionType ut = this.type();
                Datatype ct = ut.getComponent((int)tag).type;
                if (!ct.equals(cb.type())) {
                    throw new AccessorException("Binding of " + String.valueOf(ct) + " expected.");
                }
                TObjectIntHashMap ids = new TObjectIntHashMap(0);
                int len = Endian.getUIntLength(this.count() - 1);
                Serializer s = this.params.serializerScheme.getSerializer(cb);
                ids.clear();
                this.b.setLength(len += s.getSize(cv, (TObjectIntHashMap<Object>)ids));
                this.b.position(0L);
                Endian.putUInt(this.b, tag, this.count() - 1);
                s.serialize(this.b, (TObjectIntHashMap<Object>)ids, cv);
                ListenerEntry le = this.listeners;
                while (le != null) {
                    UnionInterestSet is = (UnionInterestSet)le.getInterestSet();
                    if (is.inNotificationsOf(tag)) {
                        MutableVariant newComponentValue = null;
                        if (is.inValuesOf(tag)) {
                            newComponentValue = new MutableVariant(cb, cb.isImmutable() ? cv : cb.clone(cv));
                        }
                        UnionValueAssigned e = new UnionValueAssigned(newTag, newComponentValue);
                        this.emitEvent(le, e);
                    }
                    le = le.next;
                }
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
            catch (AdaptException e) {
                throw new AccessorException(e);
            }
            catch (SerializerConstructionException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void addListener(Accessor.Listener listener, InterestSet interestSet, ChildReference path, Executor executor) throws AccessorException {
        super.addListener(listener, interestSet, path, executor);
        UnionInterestSet is = (UnionInterestSet)interestSet;
        if (is.componentInterests != null) {
            int tag = this.getTag();
            InterestSet cis = is.componentInterests[tag];
            if (cis == null) {
                return;
            }
            BinaryObject sa = this.getExistingAccessor();
            if (sa == null) {
                return;
            }
            ChildReference childPath = ChildReference.concatenate(path, new IndexReference(tag));
            sa.addListener(listener, cis, childPath, executor);
        }
    }

    @Override
    public void removeListener(Accessor.Listener listener) throws AccessorException {
        ListenerEntry e = this.detachListener(listener);
        if (e == null) {
            return;
        }
        UnionInterestSet is = (UnionInterestSet)e.interestSet;
        if (is.componentInterests != null) {
            int i = 0;
            while (i < is.componentInterests.length) {
                InterestSet cis = is.componentInterests[i];
                if (cis != null) {
                    BinaryObject sa = this.getExistingAccessor();
                    if (sa == null) {
                        return;
                    }
                    sa.removeListener(listener);
                }
                ++i;
            }
        }
    }

    @Override
    Event applyLocal(Event e, boolean makeRollback) throws AccessorException {
        UnionValueAssigned rollback = null;
        if (makeRollback) {
            try {
                UnionType ut = this.type();
                int tag = this.getTag();
                Datatype ct = ut.getComponent((int)tag).type;
                Binding cb = this.params.bindingScheme.getBinding(ct);
                Object cv = this.getComponentValue(cb);
                MutableVariant v = new MutableVariant(cb, cv);
                rollback = new UnionValueAssigned(tag, v);
            }
            catch (BindingConstructionException e2) {
                throw new AccessorException(e2);
            }
        }
        if (e instanceof ValueAssigned) {
            ValueAssigned va = (ValueAssigned)e;
            this.setValueNoflush(va.newValue.getBinding(), va.newValue.getValue());
            return rollback;
        }
        if (e instanceof UnionValueAssigned) {
            UnionValueAssigned ua = (UnionValueAssigned)e;
            if (ua.tag < 0 || ua.tag >= this.type().getComponentCount()) {
                throw new AccessorException("Tag index (" + ua.tag + ") out of bounds.");
            }
            if (!ua.newValue.type().equals(this.type().getComponent((int)ua.tag).type)) {
                throw new AccessorException("Cannot assign " + String.valueOf(ua.newValue.type()) + " to " + String.valueOf(this.type().getComponent((int)ua.tag).type));
            }
            this.setComponentValueNoflush(ua.tag, ua.newValue.getBinding(), ua.newValue.getValue());
            return rollback;
        }
        throw new AccessorException("Cannot apply " + e.getClass().getName() + " to Union Type");
    }
}

