/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard;

import java.util.HashMap;
import java.util.Map;
import org.simantics.databoard.method.Interface;
import org.simantics.databoard.method.MethodInterface;
import org.simantics.databoard.method.MethodNotSupportedException;
import org.simantics.databoard.method.MethodTypeBinding;
import org.simantics.databoard.method.MethodTypeDefinition;

class MethodComposition
implements MethodInterface {
    MethodInterface[] interfaces;
    Map<MethodTypeDefinition, MethodInterface> map = new HashMap<MethodTypeDefinition, MethodInterface>();
    Interface interfaceType;

    public MethodComposition(MethodInterface ... interfaces) {
        this.interfaces = interfaces;
        MethodInterface[] methodInterfaceArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            MethodInterface mi = methodInterfaceArray[n2];
            MethodTypeDefinition[] methodTypeDefinitionArray = mi.getInterface().getMethodDefinitions();
            int n3 = methodTypeDefinitionArray.length;
            int n4 = 0;
            while (n4 < n3) {
                MethodTypeDefinition md = methodTypeDefinitionArray[n4];
                if (this.map.containsKey(md)) {
                    throw new IllegalArgumentException("Method (" + String.valueOf(md) + ") cannot be shard over multiple MethodInterface");
                }
                this.map.put(md, mi);
                ++n4;
            }
            ++n2;
        }
        MethodTypeDefinition[] methods = this.map.values().toArray(new MethodTypeDefinition[0]);
        this.interfaceType = new Interface(methods);
    }

    @Override
    public MethodInterface.Method getMethod(MethodTypeDefinition description) throws MethodNotSupportedException {
        MethodInterface mi = this.map.get(description);
        if (mi == null) {
            throw new MethodNotSupportedException(description.getName());
        }
        return mi.getMethod(description);
    }

    @Override
    public MethodInterface.Method getMethod(MethodTypeBinding binding) throws MethodNotSupportedException {
        MethodInterface mi = this.map.get(binding.getMethodDefinition());
        if (mi == null) {
            throw new MethodNotSupportedException(binding.getMethodDefinition().getName());
        }
        return mi.getMethod(binding);
    }

    @Override
    public Interface getInterface() {
        return this.interfaceType;
    }
}

