/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.units.internal.deprecated;

import java.util.ArrayList;

import org.simantics.databoard.units.internal.UnitParseException;
import org.simantics.databoard.units.internal.parser.UnitParser;

public class Unit {

	UnitPart[] parts;
	
	public Unit(UnitPart ... parts) {
		this.parts = parts;
	}

	@Override
	public String toString() {
		StringBuilder b = new StringBuilder();
		toString(b);
		return b.toString();
	}
	
	public void toString(StringBuilder b) {
		if(parts.length == 0)
			b.append('1');
		else
			for(int i=0;i<parts.length;++i) {
				if(i>0)
					b.append(".");
				parts[i].toString(b);
			}	
	}
	
	public static Unit parse(String string) throws UnitParseException {
		final ArrayList<UnitPart> parts = new ArrayList<UnitPart>();
		UnitParser parser = new UnitParser() {

			@Override
			public void visit(String baseUnit, int exponent) {
				parts.add(new UnitPart(baseUnit, Magnitude.unscaled, exponent));
			}
			
		};
		parser.unit(string, 1);
		return new Unit(parts.toArray(new UnitPart[parts.size()]));
	}
	
	public static void main(String[] args) {
		try {
			System.out.println(parse("m2/(s3/s)"));
		} catch (UnitParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
		
}
