package org.simantics.databoard.channel;

import java.io.IOException;
import java.util.concurrent.TimeoutException;

/**
 * RequestException is thrown to a requester of a service when there was a 
 * problem fulfilling the request. Typical error is problem with communication 
 * channel or with fulfulling the service. 
 *
 * Cause is (typically) one of these:
 *  o Communication problems {@link IOException}
 *  o Timeout {@link TimeoutException}
 *  o Service handler problem {@link ServiceException} 
 *
 * @author Toni Kalajainen <toni.kalajainen@iki.fi>
 */
public class RequestException extends Exception {

	private static final long serialVersionUID = 1L;

	public RequestException(Throwable cause) {
		super(cause);
	}

}
