/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.binding.reflection;

import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.UnionBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.UnionType;

/**
 * This class binds a java Enum-class with DataBoard's UnionType.
 *
 *
 * @author Toni Kalajainen
 */
public class EnumClassBinding extends UnionBinding {

    Class<Enum<?>> clazz;
    Enum<?>[] tags;
    
    public EnumClassBinding(UnionType type, Class<Enum<?>> clazz) {
        this.type = type;
        this.tags = clazz.getEnumConstants();
        this.clazz = clazz;
        
        componentBindings = new Binding[ tags.length ];
        for (int i=0; i<tags.length; i++) {
            componentBindings[i] = new ConstantBinding(type.components[i].type, tags[i]);
        }
    }
    
    @Override
    public Object create(int tag, Object value) {
        return tags[tag];
    }
    
    @Override
    public void setValue(Object union, int tag, Object value)
	throws BindingException {
    	throw new BindingException("Cannot change enum instance value");
    }
    
    @Override
    public int getTag(Object obj) throws BindingException {
        for (int i=0; i<tags.length; i++)
            if (obj==tags[i]) return i;
		throw new BindingException(obj+" is not an element of "+clazz.getSimpleName());
    }
    
    @Override
    public Object getValue(Object obj) {
        return obj;
    }
    
    @Override
    public boolean isInstance(Object obj) {
        return clazz.isInstance(obj);
    }
    
    @Override
    public boolean isImmutable() {
    	return true;
    }

    @Override
    protected boolean baseEquals(Object obj) {
    	EnumClassBinding o = (EnumClassBinding)obj;
    	return super.baseEquals(obj) && o.clazz.equals(clazz);
    }
    
    @Override
    public int baseHashCode() {
    	return super.baseHashCode() + 13 * clazz.hashCode();
    }
}
