/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.accessor.interestset;

import org.simantics.databoard.type.FloatType;

/**
 * Interest set of Float Type.
 *
 * @see FloatType
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public class FloatInterestSet extends InterestSet {
	
	public static final FloatInterestSet MONITOR_EVERYTHING = new FloatInterestSet(true, true); 
	
	/** Interested in notification (excludes the value) */
	public boolean notification = true;
	/** Interested in the value (includes notification) */  
	public boolean value = true;
	
	public FloatInterestSet(boolean notification, boolean value) {
		this.notification = notification;
		this.value = value;
	}

	/**
	 * Returns true, if interested in notifications. This does not include
	 * interest of the value.
	 * 
	 * @return true if interested in notification 
	 */
	public boolean inNotifications() {
		return notification | value;
	}	
	
	/**
	 * Returns true, if interested in the value  
	 * 
	 * @return true if interested in the value
	 */
	public boolean inValues() {
		return value;
	}
	
}

