/*******************************************************************************
 * Copyright (c) 2010- Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.accessor.impl;

import java.util.concurrent.locks.Lock;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.adapter.AdapterFactory;
import org.simantics.databoard.binding.factory.BindingScheme;
import org.simantics.databoard.serialization.SerializerScheme;

/**
 * This class carries implementation specific accessor parameters.
 * The object is typically propagated to sub-accessors.
 *
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public class AccessorParams {
	
	public static final AccessorParams DEFAULT = new AccessorParams(null, null, Bindings.defaultBindingFactory, Bindings.adapterFactory, Bindings.serializationFactory);
	
	/*
	 * With locks there are three use scenarios:
	 * 
	 *  a) No locks
	 *  b) One lock, mutual exclusion
	 *  c) Read and write lock, See ReentrantReadWriteLock
	 * 
	 */
	
	/** Read Lock, optional */
	public Lock readLock;
	/** Write Lock, optional */
	public Lock writeLock;

	/** Binding Scheme */
	public BindingScheme bindingScheme;
	
	/** Adapter Scheme */
	public AdapterFactory adapterScheme;
	
	/** Serializer Scheme */
	public SerializerScheme serializerScheme;

	public AccessorParams(Lock readLock, Lock writeLock, BindingScheme bindingScheme, AdapterFactory adapterScheme, SerializerScheme serializerScheme) {
		this.readLock = readLock;
		this.writeLock = writeLock;
		this.bindingScheme = bindingScheme;
		this.adapterScheme = adapterScheme;
		this.serializerScheme = serializerScheme;
	}
	
}

