/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.accessor.event;

import org.simantics.databoard.accessor.reference.ChildReference;

/**
 * TODO change to Array Element S removed
 *
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public class ArrayElementRemoved extends ModificationEvent {

	public int index;

	public ArrayElementRemoved(ChildReference reference, int index) {
		this.reference = reference;
		this.index = index;
	}
	
	public ArrayElementRemoved(int index) {
		this.index = index;
	}

	@Override
	public ArrayElementRemoved clone(ChildReference newReference) {
		ArrayElementRemoved result = new ArrayElementRemoved(index);
		result.reference = newReference;
		return result;
	}

	@Override
	public String toString() {
		return toRef()+"["+index+"] -- ";
	}
	
}

