/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.util.binary;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;

/**
 * BinaryReadable is a readable stream of bytes.
 * 
 * Common interface for ByteBuffer, byte[], InputStream, RandomAccessFile.
 * 
 * @see ByteBufferReadable
 * @see InputStreamReadable
 * @author Toni Kalajainen (toni.kalajainen@vtt.fi)
 */
public interface BinaryReadable extends DataInput {

	long skipBytes(long bytes) throws IOException;
    
    /**
     * Read buf fully
     * 
     * @param buf
     * @throws EOFException if this stream reaches the end before reading all
     *         the bytes.
     * @throws IOException if an I/O error occurs.
     */
    void readFully(ByteBuffer buf)
    throws IOException;
    
    /**
     * Read fully length bytes
     * 
     * @param buf
     * @param length
     * @throws EOFException  if this stream reaches the end before reading
     *               all the bytes.
     * @throws IOException   if an I/O error occurs.
     */
    void readFully(ByteBuffer buf, int length)
    throws IOException;
        
	long length() throws IOException;
    
	long position() throws IOException;
		
}

